# Changelog for Highcharts Stock v9.0.0 (2021-02-02)

- Most changes listed under Highcharts 9.0.0 above also apply to Highcharts Stock 9.0.0.
- Added new feature, `rangeSelector.dropdown`. This feature allows the range selector button row to be collapsed into a dropdown when space is limited. The new behavior may be forced, disabled or responsive (default).
- New graphic design for the range selector date inputs. Simplified visual appearance and flexible width based on the rendered content.
- Added native browser date pickers to the range selector. Supported browsers are Chrome, Firefox, Edge and Safari for mobile. Other browsers fall back to text inputs.
- Added [rangeSelector.buttons.title](https://api.highcharts.com/highstock/rangeSelector.buttons.title) option for assistive technology and general accessibility (#14437), and assistive technology announcement on range selector button click (#14438).

## Upgrade notes
- The range selector date input fields have a new visual appearance. See [this fiddle](https://jsfiddle.net/highcharts/vto4af69/) on how to revert to the old design.
- Range selector inputs will now be of type `date`, `datetime-local` or `time`, depending on the required granularity. For supporting browsers, date picker widgets will be presented. For non-supporting browsers, it falls back to the legacy `text` input functionality.
- Indicators no longer inform about missing dependencies in the browser console.

## Bug fixes
- Fixed #14495, the `lastVisiblePrice` label in price-indicator module overwrote the [crosshair.label.backgroundColor](https://api.highcharts.com/highstock/xAxis.crosshair.label.backgroundColor) property.
- Fixed #14416, range selector ignored the [time.timezoneOffset](https://api.highcharts.com/highstock/time.timezoneOffset) setting.
- Fixed #14826, the tooltip border color did not reflect the `upColor` of OHLC and candlestick series.
- Fixed #9744, stock toolbar overlapped left-aligned title and legend.
- Fixed memory leak in range selector, chart `load` event listeners leaked on [update](https://api.highcharts.com/highstock/plotOptions.series.point.events.update).
- Fixed #11669, enabling range selector with [update](https://api.highcharts.com/highstock/plotOptions.series.point.events.update) did not work properly.
- Fixed #14292, right-aligned range selector buttons were positioned outside the chart after animating in.
- Fixed #14691, incorrect order of annotation subtitles in pop-ups in Firefox.
- Fixed #14193, scrollbar did not work on touch devices.
- Fixed #14698, issue with how the `EMAPercent` was calculated in the DEMA and TEMA indicator.
- Fixed #14544, range selector did not fully support slashes in date inputs.
- Fixed #14505, when one of the chart series had a single point, the navigator handles could be dragged beyond the default [xAxis.minRange](https://api.highcharts.com/highstock/xAxis.minRange). The computed [minRange](https://api.highcharts.com/highstock/xAxis.minRange) was `NaN`.
- Fixed #14436, range selector styling with keyboard navigation.
- Fixed #13934, chart crashed when `dataGrouping` was disabled and axis extremes were set outside the data range.
