# Changelog for Highcharts Stock v9.1.0 (2021-05-04)

- Most changes listed under Highcharts 9.1.0 above also apply to Highcharts Stock 9.1.0.
- Added new feature, [series.dataGrouping.anchor](https://api.highcharts.com/highstock/series.dataGrouping.anchor), for controlling where grouped points are rendered within the group. See #12455.
- Added new technical indicator, Disparity Index. See #15139.
- Added new technical indicator, Directional Movement Index (DMI). See #15140.
- Added new technical indicator, Chande Momentum Oscillator (CMO). See #15142.
- Added new technical indicator, On-Balance Volume (OBV). See #15138.
- Added `currentPriceIndicator` and [lastPrice](https://api.highcharts.com/highstock/plotOptions.series.lastPrice) for multiple series (also to indicators and volume), see #14888.
- Added line series as available type for the RSI Indicator. See #14930.

## Upgrade notes
- The data grouping [smoothed](https://api.highcharts.com/highstock/plotOptions.series.dataGrouping.smoothed) property has been deprecated and has been changed to `firstAnchor`, `anchor` and `lastAnchor`.
- The default value of [linearregression.params.xAxisUnit](https://api.highcharts.com/highstock/plotOptions.linearregression.params.xAxisUnit) has been changed from `undefined` to `null`.

## Bug fixes
- Fixed #13807, adding a technical indicator in the Stock Tools when multiple axes were predefined would break the chart.
- Fixed #15218, [scrollbar.liveRedraw](https://api.highcharts.com/highstock/scrollbar.liveRedraw) defaulting to true in modern browsers did not work when scrollbar was set in chart options instead of axis options.
- Fixed #3825, when [ordinal](https://api.highcharts.com/highstock/xAxis.ordinal) axis and `dataGrouping` were enabled, panning worked unevenly in one direction.
- Fixed #14192, disabled stock tools GUI buttons when all series were invisible.
- Fixed #15157, replaced the hex, and string colors in the stock tools with the colors defined in the palette.
- Fixed #15222, `className` was not applied to [lastPrice](https://api.highcharts.com/highstock/plotOptions.series.lastPrice) crosshair.
- Fixed #6332, split tooltip didn't work correctly with flag series type with empty text property.
- Fixed #15512, dynamically added series did not use range selector data grouping.
- Fixed #13847, data labels in navigator should be disabled in the default configuration.
- Fixed #15362, corrected API and Stock Tools popup list of indicators' params.
- Fixed #15435, clipping was sometimes wrong after [update](https://api.highcharts.com/highstock/plotOptions.series.point.events.update) with stock loaded.
- Fixed #15524, dragging annotation after updating label threw and `labels.overflow` set to `justify` did not work correctly.
- Fixed #15502, vertical counter annotation did not work.
- Fixed #15424, fibonacci annotation `lineColor` and [lineColors](https://api.highcharts.com/highstock/annotations.fibonacci.typeOptions.lineColors) options did not work.
- Fixed #15445, options got mutated when creating stock chart.
- Fixed #15383, indicators did not recalculate when updating series type.
- Fixed #15384, updating flag shape did not work.
- Fixed #15005, point `dataGroup` start was not calculated correctly.
- Fixed #12116, boosted stacked chart with range selector enabled and a partial range selected threw.
- Fixed #15324, elements such as legend and title sometimes had the wrong position when using stock tools.
- Fixed #15178, console warning when using `states` in [rangeSelector.buttonTheme](https://api.highcharts.com/highstock/rangeSelector.buttonTheme) options.
- Fixed #15170, added `lang` options for indicators parameters in Stock Tools popup.
- Fixed #8603, dynamically added stock axes missed forced options, addition to #15164.
- Fixed dynamically added axis defaults in stock, axes dynamically added to stock charts got different defaults than the ones added through the chart constructor.
- Fixed #15029, improved `currentPriceIndicator` button functionality.
- Fixed #15060, range selector text input was too short when [inputBoxWidth](https://api.highcharts.com/highstock/rangeSelector.inputBoxWidth) was not set, especially in IE.
- Fixed #13858, clipping was wrong after plot height had been changed by a responsive rule firing during chart load with stock loaded.
- Fixed #15075, some Stock Tools annotations were being drawn incorrectly when [yAxis.top](https://api.highcharts.com/highstock/yAxis.top) was set.
- Fixed #15155, some line drawing tools of the Stock Tools package didn't work correctly.
- Fixed #15005, when [groupAll](https://api.highcharts.com/highstock/plotOptions.series.dataGrouping.groupAll) was set to true, group start was badly calculated.
- Fixed #13247, `getTimezoneOffset` got called with `NaN` timestamp when rendering stock chart with at least one empty series.
- Fixed #15074, [lastPrice](https://api.highcharts.com/highstock/plotOptions.series.lastPrice) color was not applied properly.
- Fixed #14197, after changing `shortPeriod` in MACD, points were missing.
- Fixed #14879, `currentPriceIndicator` label was not always visible when navigating the data set.
- Fixed #9671, updating stock chart axes through `Chart.update` with `oneToOne` set to `true` did not work correctly.
- Fixed #15128, parts of the series disappeared when redrawing a regular chart with [series.clip](https://api.highcharts.com/highstock/plotOptions.series.clip) set to `false` and stock loaded.
- Fixed #12100, unable to scroll using mousewheel inside Stock Tools popups when `mapNavigation` was enabled.
- Fixed #9738, [groupAll](https://api.highcharts.com/highstock/plotOptions.series.dataGrouping.groupAll) did not work correctly with OHLC-based series.
- Fixed #10296, navigator leaked event handlers into series and x-axis on `Series.update`.
- Fixed issue mentioned in #15060 and #15062, it was not possible to enter months starting with 1 into the range selector date input under certain conditions. When typing the extremes now only update on blur and when pressing enter, which is the same behaviour the text inputs have.
- Fixed #11930, removing dynamically added y-axes did not work correctly with `navigator` enabled, causing the removed axis to show in exported charts.
- Fixed #13876, toggling `currentPriceIndicator` button threw error.
