# Changelog for Highcharts Stock v9.3.0 (2021-10-21)

- Most changes listed under Highcharts 9.3.0 above also apply to Highcharts Stock 9.3.0.
- Added new annotation, Ellipse. See [#15008](https://github.com/highcharts/highcharts/issues/15008).
- Added new annotation, Time Cycles. See [#15826](https://github.com/highcharts/highcharts/issues/15826).
- Added new annotation Fibonacci Time Zones. See [#15825](https://github.com/highcharts/highcharts/issues/15825).
- VBP indicator now follows the main series when the compare mode is on and [compareToMain](https://api.highcharts.com/highstock/series.vbp.compareToMain) is `false`. See [#16277](https://github.com/highcharts/highcharts/issues/16277).
- Added new feature [Cumulative Sum](https://www.highcharts.com/docs/stock/cumulative-sum). See [#1536](https://github.com/highcharts/highcharts/issues/1536)1.
- Added Disparity Index `average` parameter as a dropdown in the Stock Tools popup. See [#16159](https://github.com/highcharts/highcharts/issues/16159).
- Removed `requiredIndicators` info and added EMA to the default `indicators` master. See [#1540](https://github.com/highcharts/highcharts/issues/1540)9.
- Added new series type: `HLC`, see [#15346](https://github.com/highcharts/highcharts/issues/15346).

## Upgrade notes
- Changed the default SMA `index` parameter from `0` (open) to `3`(close). This also has an impact on the other indicators where SMA is being used, namely  MACD, Price Envelopes and the Linear regression family.
- Renamed Arrow Infinity Line lang name from `lang.arrowLine` to `lang.arrowInfinityLine`.

## Bug fixes
- Fixed [#16158](https://github.com/highcharts/highcharts/issues/16158), the Stock Tools indicator popup had wrong series selected by default in some cases.
- Fixed [#15727](https://github.com/highcharts/highcharts/issues/15727), the annotation popup was hidden when dragging from input to outside popup.
- Fixed [#16316](https://github.com/highcharts/highcharts/issues/16316), [#16370](https://github.com/highcharts/highcharts/issues/16370) the positions of annotations were not calculated properly on ordinal axes.
- Fixed [#16319](https://github.com/highcharts/highcharts/issues/16319), grouped positions were not calculated correctly after clicking the range selector's All button multiple times.
- Fixed [#16447](https://github.com/highcharts/highcharts/issues/16447), a separate axis was not visible after adding the Chaikin oscillator through Stock Tools.
- Fixed [#14055](https://github.com/highcharts/highcharts/issues/14055), ordinal axis and data grouping didn't work with the boost module.
- Fixed [#16449](https://github.com/highcharts/highcharts/issues/16449), the rectangle annotation added via Stock Tools was rendering without one side.
- Fixed [#16513](https://github.com/highcharts/highcharts/issues/16513), the navigator was shrinking after adding points when stuck to axis minimum.
- Fixed [#16451](https://github.com/highcharts/highcharts/issues/16451), unable to add annotation through Stock Tools on a logarithmic axis.
- Fixed [#16415](https://github.com/highcharts/highcharts/issues/16415), changed default SMA `index` parameter, added an `index` to Keltner channels indicator.
- Fixed [#16234](https://github.com/highcharts/highcharts/issues/16234), the popup of basic annotation shapes displayed label options.
- Fixed [#16390](https://github.com/highcharts/highcharts/issues/16390), a regression in a documentation article and demo. Multiple lines indicator didn't work after changes related to migrating MultipleLines mixin to composition.
- Fixed [#16041](https://github.com/highcharts/highcharts/issues/16041), long flag labels were not distributed properly which resulted in removing them.
- Fixed [#16139](https://github.com/highcharts/highcharts/issues/16139), changed Arrow Infinity Line lang name from `lang.arrowLine` to `lang.arrowInfinityLine`.
- Fixed [#16318](https://github.com/highcharts/highcharts/issues/16318), corrected the `langKey` property in Stock Tools gui for the Crooked Line 5 annotation.
- Fixed [#13868](https://github.com/highcharts/highcharts/issues/13868), [#16085](https://github.com/highcharts/highcharts/issues/16085), hovering over a `pie` series in a stock chart generated errors in the console.
- Fixed [#16255](https://github.com/highcharts/highcharts/issues/16255), error after setting new extremes in a chart with ordinal axis and invisible series.
