# Changelog for Highcharts v10.0.0 (2022-03-07)

- Adde new series type, [arc diagram](https://www.highcharts.com/docs/chart-and-series-types/arc-diagram).
- Added [breadcrumbs](https://api.highcharts.com/highcharts/drilldown.breadcrumbs) functionality for drilldown charts as well as hierarchical series like treemaps and sunburst. This replaces the drill-up and traverse-up buttons.
- Added new feature [chart.alignThresholds](https://api.highcharts.com/highcharts/chart.alignThresholds) for aligning the thresholds in charts with multiple axes.
- Added new options [hangingIndentTranslation](https://api.highcharts.com/highcharts/plotOptions.organization.hangingIndentTranslation) and [minNodeLength](https://api.highcharts.com/highcharts/plotOptions.organization.minNodeLength) for Organization chart, for improving the layout of deep structures. See [#13915](https://github.com/highcharts/highcharts/issues/13915).
- Added new option `Highcharts.AST.bypassHTMLFiltering` for disabling AST filtering.
- Added option, [boost.pixelRatio](https://api.highcharts.com/highcharts/boost.pixelRatio), providing Retina and device pixel ratio support to the Boost module.
- Added `areaspline` series to the supported series in the Boost module, see [#8288](https://github.com/highcharts/highcharts/issues/8288).

## Upgrade notes
- In an organization chart, children of a parent with `hanging` layout will now inherit this layout. To prevent this, set `layout = "normal"` for these nodes.
- The [drilldown.drillUpButton](https://api.highcharts.com/highcharts/drilldown.drillUpButton) options set is deprecated and replaced by [drilldown.breadcrumbs](https://api.highcharts.com/highcharts/drilldown.breadcrumbs). Some but not all settings are backwards compatible. See our [demo of mimicking the legacy button style](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/breadcrumbs/single-button/) with breadcrumbs. The same is true for [treemap.traverseUpButton](https://api.highcharts.com/highcharts/plotOptions.treemap.traverseUpButton).
- The offline exporting module now requires version 2 of jsPDF and version 2 of svg2pdf when exporting to PDF. Our own CDN, downloads and packages are updated, but if you're loading old releases from elsewhere, it will fail.

## Bug fixes
- Fixed [#15133](https://github.com/highcharts/highcharts/issues/15133), data labels were missing the fade-in effect upon drilling down.
- Fixed [#16470](https://github.com/highcharts/highcharts/issues/16470), setting custom drag handle cursor in options.
- Fixed [#16873](https://github.com/highcharts/highcharts/issues/16873), Windows High Contrast Mode not detected in non-Microsoft browsers.
- Migrated global win to window. This will mask the global window object in every Highcharts bundle, so that always `Highcharts.win === window`.
- Fixed [#16788](https://github.com/highcharts/highcharts/issues/16788), accessibility issue with some columns not being focusable because of wrong `point.isInside` flag.
- Fixed [#16431](https://github.com/highcharts/highcharts/issues/16431), data points were trimmed due to axis floating-point rounding.
- Fixed [#6884](https://github.com/highcharts/highcharts/issues/6884), console errors related to style attributes because of Content Security Policy.
- Fixed [#16979](https://github.com/highcharts/highcharts/issues/16979), only one point per x value was shown when [stacking](https://api.highcharts.com/highcharts/plotOptions.series.stacking) set to `percent`.
- Fixed [#16974](https://github.com/highcharts/highcharts/issues/16974), esc keypress keyboard focus issue with multiple charts on the same page.
- Fixed [#16818](https://github.com/highcharts/highcharts/issues/16818), issue with keyboard navigation and [legend.labelFormatter](https://api.highcharts.com/highcharts/legend.labelFormatter).
- Fixed [#14175](https://github.com/highcharts/highcharts/issues/14175), enabling and disabling [dataLabels.rotation](https://api.highcharts.com/highcharts/plotOptions.series.dataLabels.rotation) misplaced data label's position.
- Fixed [#16474](https://github.com/highcharts/highcharts/issues/16474), added missing click event callback on sides of the 3D pie slices.
- Fixed [#16893](https://github.com/highcharts/highcharts/issues/16893), [series.findNearestPointBy](https://api.highcharts.com/highcharts/plotOptions.series.findNearestPointBy) set to `xy` was not working well with Boost.
- Fixed [#16791](https://github.com/highcharts/highcharts/issues/16791), exporting a chart in styled mode on Safari v15 produced a black image.
- Fixed [#11712](https://github.com/highcharts/highcharts/issues/11712), in node-based series types like dependency wheel and network graph, calling `node.update()` in the [afterAnimate](https://api.highcharts.com/highcharts/plotOptions.series.events.afterAnimate) event would throw errors.
- Fixed [#16339](https://github.com/highcharts/highcharts/issues/16339), keyboard focus management issues with fullscreen change.
- Fixed [#16884](https://github.com/highcharts/highcharts/issues/16884), smarter defaults for accessible point descriptions.
- Fixed [#16045](https://github.com/highcharts/highcharts/issues/16045), tooltip with opacity was not fully hidden when hovering over a reset zoom button.
- Fixed [#6417](https://github.com/highcharts/highcharts/issues/6417), added support for non-ASCII characters (Chinese, Russian etc) in exported PDF via the new [exporting.pdfFont](https://api.highcharts.com/highcharts/exporting.pdfFont) property.
- Fixed issues with [data.enablePolling](https://api.highcharts.com/highcharts/data.enablePolling) and Google Sheets.
- Fixed issue with data module updates when `dataGrouping` options were present.
- Fixed [#16820](https://github.com/highcharts/highcharts/issues/16820), adding drilldown series on point mouseover threw an error.
- Fixed [#16169](https://github.com/highcharts/highcharts/issues/16169), stack order was affected when [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) enabled and `reversedStacks` set to false.
- Fixed [#16479](https://github.com/highcharts/highcharts/issues/16479), `resetZoomButton` was not visible after drilling up to a level with zoom.
- Fixed [#16568](https://github.com/highcharts/highcharts/issues/16568), setting `data` options with `Highcharts.setOptions` did not work.
- Fixed [#16135](https://github.com/highcharts/highcharts/issues/16135), after drill-up, the series did not go back to its original state.
- Fixed [#16589](https://github.com/highcharts/highcharts/issues/16589), SVG export broken when accessibility module was included.
- Fixed issue on mobile where a point would be highlighted visually after drilldown with a11y module loaded.
- Fixed keyboard nav issues [#16633](https://github.com/highcharts/highcharts/issues/16633), [#16634](https://github.com/highcharts/highcharts/issues/16634), [#16625](https://github.com/highcharts/highcharts/issues/16625).
- Fixed legend keyboard navigation issues [#16520](https://github.com/highcharts/highcharts/issues/16520), [#16545](https://github.com/highcharts/highcharts/issues/16545), [#16467](https://github.com/highcharts/highcharts/issues/16467).
- Fixed [#16497](https://github.com/highcharts/highcharts/issues/16497), legend keyboard navigation caused page scroll with container scaling.
- Fixed [#10525](https://github.com/highcharts/highcharts/issues/10525), setting [tickPositions](https://api.highcharts.com/highcharts/xAxis.tickPosition) to `undefined` didn't clear options.
- Fixed [#16697](https://github.com/highcharts/highcharts/issues/16697), legend item style changed when using the keyboard to focus it.
- Fixed [#16596](https://github.com/highcharts/highcharts/issues/16596), the first column point of categorized x-axis wasn't draggable.
