# Changelog for Highcharts v10.1.0 (2022-04-29)

- Added [allowMutatingData](https://api.highcharts.com/highcharts/chart.allowMutatingData) chart property to prevent data mutation while updating series or point. See [#4259](https://github.com/highcharts/highcharts/issues/4259).
- Added new option, [accessibility.point.describeNull](https://api.highcharts.com/accessibility.point.describeNull).
- Added new fullscreen events, [fullscreenOpen](https://api.highcharts.com/highcharts/chart.events.fullscreenOpen) and [fullscreenClose](https://api.highcharts.com/highcharts/chart.events.fullscreenClose), callback functions to modify chart options during toggle fullscreen mode. See [#16968](https://github.com/highcharts/highcharts/issues/16968).
- Added warning by default when the `accessibility.js` module is not loaded.
- Added new option, [accessibility.series.descriptionFormat](https://api.highcharts.com/highcharts/accessibility.series.descriptionFormatter).
- Improved the theme colors for high contrast light and high contrast dark to show more hue variance.
- Reduced verbosity of accessibility information by default.
- Changed the default value of [SVGElement.show](https://api.highcharts.com/class-reference/Highcharts.SVGElement#show)'s `inherit` argument to `true`.
- Added option to remember keyboard focus for points: `accessibility.keyboardNavigation.seriesNavigation.rememberPointFocus`.
- Added new option [pie.thickness](https://api.highcharts.com/highcharts/series.pie.thickness) describing thickness ring of pie. This option takes precedence over [pie.innerSize](https://api.highcharts.com/highcharts/series.pie.innerSize). See [#6647](https://github.com/highcharts/highcharts/issues/6647).

## Bug fixes
- Fixed [#8324](https://github.com/highcharts/highcharts/issues/8324), an error was thrown when calling `drillUp()` after `chart.applyDrilldown()`.
- Fixed [#17188](https://github.com/highcharts/highcharts/issues/17188), an incorrect breadcrumbs list was generated when drilling down the axis category.
- Improved default behavior of accessibility module with axis descriptions as well as landmark roles.
- Fixed [#15178](https://github.com/highcharts/highcharts/issues/15178), warning of invalid attribute for Reset Zoom button.
- Fixed [#17146](https://github.com/highcharts/highcharts/issues/17146), a regression in v10 with parsing of HTML with inline style rules containing a colon.
- Fixed [#14320](https://github.com/highcharts/highcharts/issues/14320), the table was not re-rendered after a data update.
- Part of [#15863](https://github.com/highcharts/highcharts/issues/15863), the scrollbar is no longer initially rendered with `y: -9999`.
- Fixed [#9687](https://github.com/highcharts/highcharts/issues/9687), vertical data label suppressed when close to the right edge of the plot area.
- Fixed [#17100](https://github.com/highcharts/highcharts/issues/17100), excessive padding in some cases when [tickAmount](https://api.highcharts.com/highcharts/xAxis.tickAmount) was set.
- Fixed [#16921](https://github.com/highcharts/highcharts/issues/16921), regression causing the wrong size of a hovered heatmap cell after zooming in.
