# Changelog for Highcharts v11.0.0 (2023-04-25)

- Design facelift with clearer, more vivid palette, added contrast for text labels and many minor visual changes.
- Added new series type, treegraph. [Read more in the docs](https://www.highcharts.com/docs/chart-and-series-types/treegraph-chart).
- Added new series type, [pictorial](https://www.highcharts.com/docs/chart-and-series-types/pictorial).
- Removed support for IE 8 and older.
- Changed the default builds to ECMAScript version ES2016.
- Replaced SASS files for [styledMode](https://api.highcharts.com/highcharts/chart.styledMode) with updated CSS files. Highcharts theming is now easier by supporting CSS variables as well as `prefers-color-scheme`. See [style by CSS](https://www.highcharts.com/docs/chart-design-and-style/style-by-css).
- [Sonification module v2](https://www.highcharts.com/docs/sonification/getting-started) with many new features for audio charts, now part of the official API.
- Changed default [rotationMode](https://api.highcharts.com/highcharts/plotOptions.sunburst.dataLabels.rotationMode) to `circular` for sunburst data labels.
- Added [minorTicksPerMajor](https://api.highcharts.com/highcharts/xAxis.minorTicksPerMajor) option for axes, see [#13338](https://github.com/highcharts/highcharts/issues/13338).
- Added the `point.percentage` property for gauge charts, see [#18433](https://github.com/highcharts/highcharts/issues/18433).
- Added `ResizeObserver` to the chart so it could adjust reflow on container size change, closes [#17924](https://github.com/highcharts/highcharts/issues/17924).

## Upgrade notes
- To revert to the old design, use the theme defined in the [v10 theme sample](https://www.highcharts.com/samples/highcharts/members/theme-v10).
- Font sizes of the chart are now using `rem` by default. This may cause too small or too big fonts if your web page is using non-default root element font size. To avoid that, set [chart.style.fontSize](https://api.highcharts.com/highcharts/chart.style) to `16px` or any other values you see fit.
- The top-level `labels` option has been deprecated for a long time and is now removed. Use [Annotations](https://www.highcharts.com/docs/advanced-chart-features/annotations-module) instead.
- Time-related settings on the [global](https://api.highcharts.com/highcharts/global) options structure are removed. Use the [time](https://api.highcharts.com/highcharts/time) options instead.
- The new version of the sonification module is not backwards compatible with the old, experimental module.
- The default builds were changed to ECMAScript version ES2016. See the [system requirements](https://www.highcharts.com/docs/getting-started/system-requirements) on how to support IE11 and other legacy browsers.
- If you're using [chart.styledMode](https://api.highcharts.com/highcharts/chart.styledMode), and your end users have [prefers-color-scheme](https://developer.mozilla.org/en-US/docs/Web/CSS/@media/prefers-color-scheme) set to `dark` in their browsers, they may now be presented with dark-themed charts. The exception is if your CSS overrides the default coloring.
- Changed default [rotationMode](https://api.highcharts.com/highcharts/plotOptions.sunburst.dataLabels.rotationMode) to `circular` for sunburst data labels.

## Bug fixes
- Fixed [#18790](https://github.com/highcharts/highcharts/issues/18790), custom symbols were incorrectly positioned in some cases.
- Fixed [#18103](https://github.com/highcharts/highcharts/issues/18103), Y zoom while panning on top of the plot when chart inverted was not working.
- Fixed [#18066](https://github.com/highcharts/highcharts/issues/18066), after updating the series data to one point with category xAxis there were unwanted labels.
- Fixed [#17720](https://github.com/highcharts/highcharts/issues/17720), the tooltip with enabled [outside](https://api.highcharts.com/highcharts/tooltip.outside) and [split](https://api.highcharts.com/highcharts/tooltip.split) properties was badly positioned for some series.
- Fixed [#18693](https://github.com/highcharts/highcharts/issues/18693), [tooltip.stickOnContact](https://api.highcharts.com/highcharts/tooltip.stickOnContact) threw errors on hover between one series with `followPointer` set to true and the second series `followPointer` set to false.
- Fixed [#18741](https://github.com/highcharts/highcharts/issues/18741), incorrect guide box behaviour while dragging stacked bars.
- Fixed [#14080](https://github.com/highcharts/highcharts/issues/14080), bubble legend didn't work correctly if the `legendItemClick` event for one series was prevented.
- Fixed [#18635](https://github.com/highcharts/highcharts/issues/18635), bad tooltip position in an inverted chart inside a scrollable container when [tooltip.outside](https://api.highcharts.com/highcharts/tooltip.outside) was true.
- Fixed [#17614](https://github.com/highcharts/highcharts/issues/17614), timeline styled mode default colors.
- Fixed [#18617](https://github.com/highcharts/highcharts/issues/18617), stack labels in inverted charts were mispositioned in the y axis.
- Fixed [#18636](https://github.com/highcharts/highcharts/issues/18636), waterfall lines missing when there was a `null` point.
- Fixed [#17168](https://github.com/highcharts/highcharts/issues/17168), the Sunburst series didn’t work properly when the chart was inverted.
- Fixed [#17257](https://github.com/highcharts/highcharts/issues/17257), item chart points color wasn't updating.
- Fixed [#17280](https://github.com/highcharts/highcharts/issues/17280), bubbles with `z: 0` caused points to disappear.
- Fixed [#16516](https://github.com/highcharts/highcharts/issues/16516), legend symbol height didn't accept 0 as a value.
- Fixed [#18501](https://github.com/highcharts/highcharts/issues/18501), vertical alignment of stack labels didn't work with logarithmic axes.
- Fixed [#18502](https://github.com/highcharts/highcharts/issues/18502), `pointPadding` for heatmap series wasn't working with reversed axes.
- Fixed [#18444](https://github.com/highcharts/highcharts/issues/18444), a polar chart with type "bar" and data labels caused JavaScript error.
- Fixed [#17912](https://github.com/highcharts/highcharts/issues/17912), column range points were not aligned with column points.
- Fixed [#18443](https://github.com/highcharts/highcharts/issues/18443), the `className` property in [guideBox](https://api.highcharts.com/highcharts/plotOptions.series.dragDrop.guideBox) didn't work for drag & drop.
- Fixed [#10005](https://github.com/highcharts/highcharts/issues/10005), wrong series name and legend item by using [data.seriesMapping](https://api.highcharts.com/highcharts/data.seriesMapping) property.
- Fixed [#18422](https://github.com/highcharts/highcharts/issues/18422), stacked polar column chart with zero value rendered a wedge across the whole y axis.
- Fixed [#16675](https://github.com/highcharts/highcharts/issues/16675), adding annotation from a custom button was not possible if the button had a custom SVG symbol.
- Fixed [#18305](https://github.com/highcharts/highcharts/issues/18305), updating series marker size was not working if the initial size was not set.
