# Changelog for Highcharts v11.1.0 (2023-06-05)

- Added support for mouse wheel zooming through [chart.zooming.mouseWheel](https://api.highcharts.com/highcharts/chart.zooming.mouseWheel). This feature is embedded in the [Highcharts Stock bundle](https://code.highcharts.com/stock/highstock.js), but requires an [additional module file](https://code.highcharts.com/modules/mouse-wheel-zoom.js) for the [Highcharts bundle](https://code.highcharts.com/highcharts.js).
- Added the [heatmap.interpolation](https://api.highcharts.com/highcharts/plotOptions.heatmap.interpolation) option for creating smooth heatmaps.
- Added new function, [Chart.getOptions()](https://api.highcharts.com/class-reference/Highcharts.Chart#getOptions), to get the current active configuration options for the chart.
- Added the [treegraph.fillSpace](https://api.highcharts.com/highcharts/series.treegraph.fillSpace) option for treegraphs to fill the whole plot area even when some points are collapsed.
- Added `borderRadius` option support for funnel and pyramid series. See [#18839](https://github.com/highcharts/highcharts/issues/18839).

## Bug fixes
- Fixed [#18869](https://github.com/highcharts/highcharts/issues/18869), redundant chart redraws on changing title, subtitle or caption font size, or top level chart font size.
- Fixed [#19017](https://github.com/highcharts/highcharts/issues/19017), failure in parsing negative numbers with spaces in the data module.
- Fixed [#19053](https://github.com/highcharts/highcharts/issues/19053), a regression since 10.3 causing item series update not to work correctly.
- Fixed [#19051](https://github.com/highcharts/highcharts/issues/19051), axis crossing was not always correct.
- Fixed [#18985](https://github.com/highcharts/highcharts/issues/18985), updating [enableMouseTracking](https://api.highcharts.com/highcharts/plotOptions.series.enableMouseTracking) from `true` to `false` didn't work.
- Fixed [#17589](https://github.com/highcharts/highcharts/issues/17589), update of multiple data labels didn't work in specific conditions.
- Fixed [#17791](https://github.com/highcharts/highcharts/issues/17791), `pointRange` wasn't calculated for multiple series with single points.
- Fixed [#19028](https://github.com/highcharts/highcharts/issues/19028), border radius was wrongly applied for negative column points when the [zoneAxis](https://api.highcharts.com/highcharts/plotOptions.series.zoneAxis) option was `x`.
- Fixed [#12063](https://github.com/highcharts/highcharts/issues/12063), packed bubble parent nodes had a bad position after width update.
- Fixed [#18891](https://github.com/highcharts/highcharts/issues/18891), invisible data labels in treegraph series reacted to hover.
- Fixed [#18960](https://github.com/highcharts/highcharts/issues/18960), a regression in v11, wrong placement for data labels in dumbbell series.
- Fixed [#18110](https://github.com/highcharts/highcharts/issues/18110), `yAxis.maxPadding` was ignored when [yAxis.softMin](https://api.highcharts.com/highcharts/yAxis.softMin) was set.
- Fixed [#18956](https://github.com/highcharts/highcharts/issues/18956), a regression causing small sankey nodes rendering as circles.
- Fixed [#18876](https://github.com/highcharts/highcharts/issues/18876), updating the `tooltip` didn't work when wasn't declared in the chart configuration.
