# Changelog for Highcharts v11.2.0 (2023-10-30)

- Upgraded the build pipeline to benefit from new language features. Bundles are now compiled to ES2020 by the TypeScript compiler (`*.src.js` files), and minified by swc (`*.js` files).
- Added support for multiple data labels on pie slices.
- Added new option, [sankey.nodeAlignment](https://api.highcharts.com/highcharts/series.sankey.nodeAlignment) for the Sankey series to specify which side of the chart nodes should align.
- Added new option, [sankey.linkColorMode](https://api.highcharts.com/highcharts/series.sankey.linkColorMode).
- Added feature to allow different symbols for upper/lower markers in area range and dumbbell charts. See [#14024](https://github.com/highcharts/highcharts/issues/14024).
- Set the default [series.lineWidth](https://api.highcharts.com/highcharts/plotOptions.series.lineWidth) of line graphs to 2px for better accessibility.

## Bug fixes
- Fixed [#19552](https://github.com/highcharts/highcharts/issues/19552), treegraph was losing node parent during export.
- Fixed [#19885](https://github.com/highcharts/highcharts/issues/19885), `axis.breaks` didn't work with zooming.
- Fixed [#13240](https://github.com/highcharts/highcharts/issues/13240), using default data labels alignment for bubble series.
- Fixed [#19826](https://github.com/highcharts/highcharts/issues/19826), Lollipop grouping didn't work correctly.
- Fixed [#19934](https://github.com/highcharts/highcharts/issues/19934), CSV export was broken in Safari.
- Fixed [#19480](https://github.com/highcharts/highcharts/issues/19480), added missing TypeScript definitions for `PlotLineOrBand` properties.
- Fixed [#17820](https://github.com/highcharts/highcharts/issues/17820), clip rect did not take into account boosted navigator.
- Fixed [#17014](https://github.com/highcharts/highcharts/issues/17014), `boostThreshold` with null point threw an error.
- Fixed [#19762](https://github.com/highcharts/highcharts/issues/19762), offline export PDF documents didn't scale.
- Fixed [#19671](https://github.com/highcharts/highcharts/issues/19671), treegraph was throwing an error when setting [legendSymbol](https://api.highcharts.com/highcharts/plotOptions.series.legendSymbol) to `lineMarker`.
- Fixed [#14108](https://github.com/highcharts/highcharts/issues/14108), start and end dates in exported CSV data for X-range series.
- Fixed [#19744](https://github.com/highcharts/highcharts/issues/19744), series' `clip` option was not working in polar charts.
- Fixed [#19725](https://github.com/highcharts/highcharts/issues/19725), drilling between cartesian and non-cartesian series didn’t work properly.
- Fixed [#19692](https://github.com/highcharts/highcharts/issues/19692), mouse wheel zoom was enabled even when general zoom was not.
- Fixed [#19253](https://github.com/highcharts/highcharts/issues/19253), Offline Export did not work for boosted series.
- Fixed [#18062](https://github.com/highcharts/highcharts/issues/18062), pinch to zoom didn't work on Android Mobile devices after any click on the chart.
- Fixed [#19314](https://github.com/highcharts/highcharts/issues/19314), tooltip chevron was cut off when [outside](https://api.highcharts.com/highcharts/tooltip.outside) was enabled.
- Fixed [#19616](https://github.com/highcharts/highcharts/issues/19616), breadcrumbs disappeared when invoking `chart.update` in sunburst and treemap.
- Fixed [#19362](https://github.com/highcharts/highcharts/issues/19362), x-range series tooltip lost its correct default date and time formatting.
- Fixed [#19148](https://github.com/highcharts/highcharts/issues/19148), NaN x value disabled area chart graphic elements.
- Fixed [#19457](https://github.com/highcharts/highcharts/issues/19457), multiple `dataLabels` enabled/disabled threw render (console) error.
- Fixed [#19524](https://github.com/highcharts/highcharts/issues/19524), treegraph links weren't disappearing after calling `setData`.
- Fixed [#19343](https://github.com/highcharts/highcharts/issues/19343), tooltip positioning on xrange points lying on shifted axes.
- Fixed [#19368](https://github.com/highcharts/highcharts/issues/19368), `TreeGraph` chart displayed extra node expander for hidden child when levels collapsed. Also fixed `collapseButton` visibility.
- Fixed [#19341](https://github.com/highcharts/highcharts/issues/19341), null points could be hovered in the boost module.
- Fixed issue with missing points in boosted heatmap with interpolation set to true.
- Fixed [#18988](https://github.com/highcharts/highcharts/issues/18988) and [#17594](https://github.com/highcharts/highcharts/issues/17594), vertical and horizontal offsets for inverted Sankey and Organization charts didn't work correctly.
- Fixed [#19516](https://github.com/highcharts/highcharts/issues/19516), read-only CSS properties weren't excluded during the export of the chart.
- Fixed [#19217](https://github.com/highcharts/highcharts/issues/19217), mobile pinch on inverted charts flipped the chart.
- Fixed [#19203](https://github.com/highcharts/highcharts/issues/19203), [plotOptions.series.pointStart](https://api.highcharts.com/highcharts/plotOptions.series.pointStart) couldn't be updated more than once.
- Fixed [#18815](https://github.com/highcharts/highcharts/issues/18815), [boostThreshold](https://api.highcharts.com/highcharts/plotOptions.series.boostThreshold) set for one series boosted all series.
- Fixed [#19374](https://github.com/highcharts/highcharts/issues/19374), disabled `keyboardNavigation` didn't remove the exit anchor.
- Fixed [#19465](https://github.com/highcharts/highcharts/issues/19465), wrong property in [numberFormatter](https://api.highcharts.com/highcharts/chart.numberFormatter) API demo.
- Fixed [#19412](https://github.com/highcharts/highcharts/issues/19412), `chart.zooming.resetZoom` position settings were overwritten by the deprecated parameter.
- Fixed [#19110](https://github.com/highcharts/highcharts/issues/19110), chart's height, and [minLinkWidth](https://api.highcharts.com/highcharts/plotOptions.sankey.minLinkWidth) misaligned sankey links.
- Fixed [#19178](https://github.com/highcharts/highcharts/issues/19178), some `yAxis` options were disappearing after mouse wheel zoom.
- Fixed [#19200](https://github.com/highcharts/highcharts/issues/19200), styles were not applied to the annotation label when `useHTML` was enabled.
- Fixed [#19202](https://github.com/highcharts/highcharts/issues/19202), excluded `events.legendItemClick` from _item_ series API.
- Fixed [#19179](https://github.com/highcharts/highcharts/issues/19179), changing the crop property on annotations through `annotationOptions` in the chart config did not work.
- Fixed [#15441](https://github.com/highcharts/highcharts/issues/15441), auto-scroll did not follow tooltip when navigating with keyboard while zoomed in.
- Fixed [#17170](https://github.com/highcharts/highcharts/issues/17170), data labels with outline or shadow were misplaced in PDF files exported using the offline exporting module.
- Fixed [#19002](https://github.com/highcharts/highcharts/issues/19002), with `a11y` enabled `<` sign was stripped, causing issues with screen readers.
- Fixed [#19027](https://github.com/highcharts/highcharts/issues/19027), a regression in v11 causing the chart to redraw twice on updates that triggered a resize of the container.
- Fixed [#19078](https://github.com/highcharts/highcharts/issues/19078), proximate legend did not work after updating the [legend.enabled](https://api.highcharts.com/highcharts/legend.enabled) property.
- Fixed [#19093](https://github.com/highcharts/highcharts/issues/19093), SVG `<filter>` issue with shadow enabled on line series when points had the same `x` or `y` value.
- Fixed [#19134](https://github.com/highcharts/highcharts/issues/19134), color and symbol changed constantly for the same series after every drill-up.
- Fixed [#19127](https://github.com/highcharts/highcharts/issues/19127), [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) was not working for column pyramid.
- Fixed [#19035](https://github.com/highcharts/highcharts/issues/19035), tooltip tap or click stopped working after pinch zoom in iOS.
- Fixed [#19143](https://github.com/highcharts/highcharts/issues/19143), a regression causing incorrect series name from CSV for packed bubble series.
