# Changelog for Highcharts v11.3.0 (2024-01-10)

- Implemented native handling of the [time.timezone](https://api.highcharts.com/highcharts/time.timezone) option, making the dependency on moment.js redundant.
- Added new options [colorAxis.width](https://api.highcharts.com/highcharts/colorAxis.width) and [colorAxis.height](https://api.highcharts.com/highcharts/colorAxis.height), allowing absolute or relative size. See [#17870](https://github.com/highcharts/highcharts/issues/17870).
- Added new option [chart.axisLayoutRuns](https://api.highcharts.com/highcharts/chart.axisLayoutRuns). It allows opting in for more predictable axis tick and label layout, at the cost of performance. See [#19794](https://github.com/highcharts/highcharts/issues/19794).
- Added new default [legendSymbol](https://api.highcharts.com/highcharts/plotOptions.area.legendSymbol) for area series and its derivatives.

## Upgrade notes
- The [exporting.formAttributes](https://api.highcharts.com/highcharts/exporting.formAttributes) no longer works because the internal `post` function was replaced by the [fetch](https://api.highcharts.com/highcharts/exporting.fetchOptions) API. The [formAttributes](https://api.highcharts.com/highcharts/exporting.formAttributes) option can for some purposes be replaced with [exporting.fetchOptions](https://api.highcharts.com/highcharts/exporting.fetchOptions). See [the fetch article on MDN](https://developer.mozilla.org/en-US/docs/Web/API/fetch) for more information about possible options.

## Bug fixes
- Fixed [#19169](https://github.com/highcharts/highcharts/issues/19169), the `focusBorder` was not removed from `SVGElement` after the element had been unfocused.
- Fixed [#20319](https://github.com/highcharts/highcharts/issues/20319), funnel point path not rendered properly when the point's top coordinates were within top boundaries of the funnel neck.
- Fixed [#20291](https://github.com/highcharts/highcharts/issues/20291), y-axis crosshair was missing for 3d column.
- Fixed [#20340](https://github.com/highcharts/highcharts/issues/20340), histogram bins [x2](https://api.highcharts.com/highcharts/series.xrange.data.x2) value was wrongly calculated.
- Fixed [#20191](https://github.com/highcharts/highcharts/issues/20191), exporting a chart using the export module caused `beforeunload` event to fire.
- Fixed [#20142](https://github.com/highcharts/highcharts/issues/20142), pie selected point was semi-transparent on legend hover in styled mode.
- Fixed [#18744](https://github.com/highcharts/highcharts/issues/18744), a point covered by an area series should be fully clickable if the tooltip shows.
- Fixed [#20129](https://github.com/highcharts/highcharts/issues/20129), the lack of root and window in the NX environment was causing an error on load.
- Fixed [#20097](https://github.com/highcharts/highcharts/issues/20097), script errors and invisible series in error bar with certain extremes.
- Fixed [#19857](https://github.com/highcharts/highcharts/issues/19857), short x-axis labels disappeared in some edge cases when `labels.autoRotation` was set.
- Fixed [#18804](https://github.com/highcharts/highcharts/issues/18804), zooming in below [boostThreshold](https://api.highcharts.com/highcharts/plotOptions.series.boostThreshold) didn't disable boost on scatter series.
- Fixed [#20120](https://github.com/highcharts/highcharts/issues/20120), data labels in packed bubble series were misaligned after updating the series position.
- Fixed [#16920](https://github.com/highcharts/highcharts/issues/16920), formalized and fixed the [data.columnTypes](https://api.highcharts.com/highcharts/data.columnTypes) option.
- Fixed [#17545](https://github.com/highcharts/highcharts/issues/17545), misplaced funnel and pyramid data labels after legend item click when `dataLabels.inside` set to false.
- Fixed [#19497](https://github.com/highcharts/highcharts/issues/19497), some points disappeared when changing extremes of the category axes in boost.
- Fixed [#20098](https://github.com/highcharts/highcharts/issues/20098), multiple data labels were not rendered when enabled in `plotOptions`.
- Fixed [#19895](https://github.com/highcharts/highcharts/issues/19895), removing a series while rendering in boost mode could cause a TypeError.
- Fixed [#20002](https://github.com/highcharts/highcharts/issues/20002), stroke wasn't applied to annotations during offline PDF export.
- Fixed [#19976](https://github.com/highcharts/highcharts/issues/19976), columns threw off center when using mouse wheel zoom.
- Fixed [#19621](https://github.com/highcharts/highcharts/issues/19621), errors instead of expected behavior when using arrow-keys to navigate first and last items in legend.
- Fixed [#19130](https://github.com/highcharts/highcharts/issues/19130), `negativeColor` was applied to positive graphs for the part of the line that extended below the threshold.
- Fixed [#19604](https://github.com/highcharts/highcharts/issues/19604), ticks were sometimes differently calculated after a series update.
- Fixed [#20007](https://github.com/highcharts/highcharts/issues/20007), contrast color setting for data labels did not respect their background colors.
- Fixed [#19946](https://github.com/highcharts/highcharts/issues/19946), nodes in the organization chart weren’t centered while using node width or height options.
- Fixed [#19917](https://github.com/highcharts/highcharts/issues/19917), setting options in a series without `series.data` would add default aria-label.
