# Changelog for Highcharts v11.4.0 (2024-03-05)

- Added new option [sankey.nodeDistance](https://api.highcharts.com/highcharts/series.sankey.nodeDistance) and the possibility of setting [sankey.nodeWidth](https://api.highcharts.com/highcharts/series.sankey.nodeWidth) to `auto`. The same option pair is also supported by organization chart and treegraph series.
- Enhanced the pinch zoom behavior to redraw the axes and series continuously. Previously it created a preview by scaling the graphs, then did a full review at the end. Also a deeper refactor and unification of the whole zoom, pan and mousewheel logic.
- Added new option [organization.hangingSide](https://api.highcharts.com/highcharts/series.organization.hangingSide) which allows nodes to hang from the right side in inverted organization charts. See  [#17240](https://github.com/highcharts/highcharts/issues/17240).

## Bug fixes
- Fixed [#20334](https://github.com/highcharts/highcharts/issues/20334), chart width exceeded container width on Windows when the chart itself caused page scrollbars.
- Fixed [#20572](https://github.com/highcharts/highcharts/issues/20572), destroying a chart after point hover sometimes produced an error.
- Fixed [#15921](https://github.com/highcharts/highcharts/issues/15921) by applying `fillColor` to series from `highContrastTheme.colors` if set.
- Fixed [#20166](https://github.com/highcharts/highcharts/issues/20166), ticks and gridlines were visible outside the axis in some corner cases.
- Fixed code scan issues [56](https://github.com/highcharts/highcharts/security/code-scanning/56), incomplete string escaping or encoding in SVGRenderer, and [72](https://github.com/highcharts/highcharts/security/code-scanning/72), incomplete multi-character sanitization in SVGRenderer.
- Fixed code scan issue [73](https://github.com/highcharts/highcharts/security/code-scanning/73), incomplete multi-character sanitization in SVGElement node title.
- Fixed code scan issue [90](https://github.com/highcharts/highcharts/security/code-scanning/90), permissive regex in `mapcharts.js`.
- Fixed code scan issue [111](https://github.com/highcharts/highcharts/security/code-scanning/111), potential prototype pollution in `Utilities.ts`.
- Fixed code scan issue [112](https://github.com/highcharts/highcharts/security/code-scanning/112), potential prototype pollution in `NavigationBinding.ts`.
- Fixed [#20329](https://github.com/highcharts/highcharts/issues/20329), detached elements and events in the Accessibility module produced a memory leak.
- Fixed [#20394](https://github.com/highcharts/highcharts/issues/20394), `series.color` only initially impacted the color of x-range points.
- Fixed [#20435](https://github.com/highcharts/highcharts/issues/20435), point events update didn't work.
- Fixed [#20516](https://github.com/highcharts/highcharts/issues/20516), `this` was not bound to plot line or plot band object in event callbacks.
- Fixed [#20429](https://github.com/highcharts/highcharts/issues/20429), toggling bellcurve visibility threw error.
- Fixed [#20440](https://github.com/highcharts/highcharts/issues/20440) and [#20569](https://github.com/highcharts/highcharts/issues/20569), multiple series zones broke graph.
- Fixed regression since v11.3, column range series had area-style legend marker.
- Fixed [#20433](https://github.com/highcharts/highcharts/issues/20433), boosted scatter chart did not work without axis min/max-options.
- Fixed [#20307](https://github.com/highcharts/highcharts/issues/20307) and [#20301](https://github.com/highcharts/highcharts/issues/20301), alignment and overlap detection for rotated data labels didn't work correctly.
- Fixed [#19730](https://github.com/highcharts/highcharts/issues/19730), [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) on inverted column chart had incorrect series order.
- Fixed [#20264](https://github.com/highcharts/highcharts/issues/20264), the packed bubble series was not rendered correctly in an inverted chart.
