# Changelog for Highcharts v11.4.2 (2024-05-22)

- Fixed [#21109](https://github.com/highcharts/highcharts/issues/21109), tooltip animation was not smooth. Added the option to set [tooltip.animation](https://api.highcharts.com/highcharts/tooltip.animation) as an animation object, not just a boolean as previously.
- Added new options [pane.background.borderRadius](https://api.highcharts.com/highcharts/pane.background.borderRadius), and [plotBands.borderRadius](https://api.highcharts.com/highcharts/yAxis.plotBands.borderRadius) for gauges.

## Bug fixes
- Fixed [#20451](https://github.com/highcharts/highcharts/issues/20451), [legend.symbolWidth](https://api.highcharts.com/highcharts/legend.symbolWidth) and [legend.symbolHeight](https://api.highcharts.com/highcharts/legend.symbolHeight) didn't change color axis dimensions if [colorAxis.width](https://api.highcharts.com/highcharts/colorAxis.width) or [colorAxis.height](https://api.highcharts.com/highcharts/colorAxis.height) were not set.
- Fixed [#20876](https://github.com/highcharts/highcharts/issues/20876), [redraw](https://api.highcharts.com/highcharts/chart.events.redraw) and [drillupall](https://api.highcharts.com/highcharts/chart.events.drillupall) events were called too many times during chart drill up.
- Fixed [#5334](https://github.com/highcharts/highcharts/issues/5334), pixel alignment issues between grid lines, column series, error bars and scatter points.
- Fixed [#20585](https://github.com/highcharts/highcharts/issues/20585), gap in the border at the bottom of bubbles at some sizes.
- Fixed [#20729](https://github.com/highcharts/highcharts/issues/20729), pressing "enter" on a tabbed point resulted in different event than clicking it with a mouse.
- Fixed chart height docs, updated `500px`-sample title, and added new demo showing height inherited from container.
- Fixed [#18776](https://github.com/highcharts/highcharts/issues/18776), the series colors were not found when boosting multiple series in a single canvas in styled mode.
- Fixed [#21125](https://github.com/highcharts/highcharts/issues/21125), a regression causing wrong positioning of bubbles in an inverted bubble chart.
- Fixed [#20564](https://github.com/highcharts/highcharts/issues/20564), minus sign was displayed for the number zero if it was rounded from a negative value.
- Fixed [#20816](https://github.com/highcharts/highcharts/issues/20816), time zone wasn't respected in Templating in format strings.
- Fixed [#20804](https://github.com/highcharts/highcharts/issues/20804), `setOptions` didn't change radial axis defaults.
- Fixed [#20146](https://github.com/highcharts/highcharts/issues/20146), dragging didn't work for the `errorbar` series.
- Fixed [#20988](https://github.com/highcharts/highcharts/issues/20988), exporting chart, then dragging an annotation and exporting again used to cause wrong annotation position in the subsequently exported charts.
- Improved the default padding of axis labels, and fixed their collision calculations.
- Fixed [#20998](https://github.com/highcharts/highcharts/issues/20998), data labels overflowed the plot area when the axis position was different from default.
- Fixed [#20405](https://github.com/highcharts/highcharts/issues/20405), a regression in network graph. When dragging a node, others didn't follow.
- Fixed [#20560](https://github.com/highcharts/highcharts/issues/20560), destroyed points in the area range series were wrongly used during mouse hover.
- Fixed [#20656](https://github.com/highcharts/highcharts/issues/20656), series with manipulated points were missing a11y description on initial load.
- Fixed [#20965](https://github.com/highcharts/highcharts/issues/20965), unwanted animation of right-aligned label when only the text changed.
- Fixed [#20784](https://github.com/highcharts/highcharts/issues/20784), a regression in v11.4.0 causing wrong min and max extremes for the selection event in column charts.
- Fixed [#20710](https://github.com/highcharts/highcharts/issues/20710), bubble legend with color-axis moved after redraw.
- Fixed [#20792](https://github.com/highcharts/highcharts/issues/20792), plot lines' HTML labels rendered incorrectly.
- Fixed [#18980](https://github.com/highcharts/highcharts/issues/18980), the `highcharts.d.ts` type definition file was too large and caused issues in editors. Moved majority of series options into separate definition files.
- Fixed [#20871](https://github.com/highcharts/highcharts/issues/20871), a regression with resetting zoom across synchronized charts.
- Fixed [#20586](https://github.com/highcharts/highcharts/issues/20586), plot line CSS classes were not concatenated with spaces, causing the `className` option to fail.
- Fixed [#20548](https://github.com/highcharts/highcharts/issues/20548), chart not resizing after closing fullscreen.
