# Changelog for Highcharts v11.4.4 (2024-07-02)

- Refactored the [series.turboThreshold](https://api.highcharts.com/highcharts/plotOptions.series.turboThreshold) option to be more forgiving. Instead of failing with a warning message, the Series class now silently skips the fast looping of raw numbers and processes the object configuration instead, at a slight performance cost.
- Introduced new event and option [legend.events.itemClick](https://api.highcharts.com/highcharts/legend.events.itemClick), deprecated `events.legendItemClick`. See [#3957](https://github.com/highcharts/highcharts/issues/3957).
- Added new option [treemap.traverseToLeaf](https://api.highcharts.com/highcharts/plotOptions.treemap.traverseToLeaf) which allows to drill into last possible leaf of Treemap series.

## Upgrade notes
- Text path support is no longer part of the `highcharts.js` main bundle, but requires loading the `modules/textpath.js` bundle. It is however built into those series that use text paths by default.

## Bug fixes
- Temporarily fixed [#21144](https://github.com/highcharts/highcharts/issues/21144), workaround for a Chromium bug while touching and scrolling chart.
- Fixed [#21098](https://github.com/highcharts/highcharts/issues/21098), various minor fixes for IE11 compatibility.
- Fixed [#21302](https://github.com/highcharts/highcharts/issues/21302), added the description to all arguments in the Tooltip constructor.
- Fixed [#20525](https://github.com/highcharts/highcharts/issues/20525), in boosted charts, markers were not being hidden when zoomed in series was hidden.
- Fixed [#21174](https://github.com/highcharts/highcharts/issues/21174), stack labels were wrongly positioned for multiple x-axes in inverted charts.
- Fixed [#21341](https://github.com/highcharts/highcharts/issues/21341), updating the height of a `SVGLabel` didn't occur immediately.
- Fixed [#19224](https://github.com/highcharts/highcharts/issues/19224), treegraph data labels did not hide when `allowOverlap` was `false`. Implemented overlap detection for labels with text path.
- Fixed [#21177](https://github.com/highcharts/highcharts/issues/21177), setting data to a hidden packed bubble series would throw error.
- Fixed [#21124](https://github.com/highcharts/highcharts/issues/21124), special character broke string label templating format.
- Fixed regression after fix [#20435](https://github.com/highcharts/highcharts/issues/20435), updating of existing point event didn't remove the old event.
- Fixed [#20969](https://github.com/highcharts/highcharts/issues/20969), tooltip did not dissappear when hovering from one chart to another.
- Fixed [#21245](https://github.com/highcharts/highcharts/issues/21245), points were wrongly positioned for multiple boxplot series.
- Fixed [#20494](https://github.com/highcharts/highcharts/issues/20494), chart did not switch back to default config upon exiting responsive conditions.
- Fixed [#21176](https://github.com/highcharts/highcharts/issues/21176), in boosted charts, the halo was wrongly animated for multiple series with multiple axes.
- Fixed [#19944](https://github.com/highcharts/highcharts/issues/19944), error message "getAttribute is not a function" appeared in certain edge cases in Firefox.
- Fixed [#16925](https://github.com/highcharts/highcharts/issues/16925), stacked area series with null data produced bad animation.
- Fixed [#11794](https://github.com/highcharts/highcharts/issues/11794), max rendered [series.lineWidth](https://api.highcharts.com/highcharts/series.line.lineWidth) for boost was 1.
