# Changelog for Highcharts v12.0.0 (2024-11-27)

- Refactored the Series class to organize its data in a `DataTable` instead of parallel arrays. Removed the internal Series properties `xData`, `yData`, `processedXData` and `processedYData`, as well as some additional series-specific data arrays, in favor of `Series.dataTable`.
- Added support for [data.x](https://api.highcharts.com/highcharts/series.line.data.x) values as date strings. These can now be defined for example as `'2024-10-03'` as a more human readable alternative to timestamps. Also allowed date string in other options referring to x values, like `xAxis.min`, `xAxis.max`, `series.pointStart`, `plotLines.value`, Gantt series start and end, `Axis.setExtremes()` etc.
- Refactored all internal time zone handling with functions powered by `Intl.DateTimeFormat`.
- Added new option, [lang.locale](https://api.highcharts.com/highcharts/lang.locale), to determine in what language dates are rendered.
- Added support for locale-aware date formatting through the [Intl.DateTimeFormat](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Global_Objects/Intl/DateTimeFormat) browser API. Changed all default datetime format strings to [locale-aware formats](https://api.highcharts.com/class-reference/Highcharts.Time#dateFormat).
- Added `ucfirst` template helper function to allow upper case first in strings.
- Added support for string parameters in template helper functions.
- Added support for `textOverflow: 'ellipsis'` with [texts](https://api.highcharts.com/class-reference/Highcharts.SVGRenderer#text) and [labels](https://api.highcharts.com/class-reference/Highcharts.SVGRenderer#label) spanning multiple lines, as well as the `lineClamp` CSS property. This allows better control over the layout of axis labels and data labels.
- Changed the [default chart font-family](https://api.highcharts.com/highcharts/chart.style) to better match system fonts and improve legibility.
- Changed the default build system to webpack, allowing for tree shaking in the build process and smaller builds.
- Improved default alignment of title, subtitle and the context menu button. Added new option, [title.minScale](https://api.highcharts.com/highcharts/title.minScale).
- Added option `legendColor` to set legend symbol color as distinct from series color, see [#21776](https://github.com/highcharts/highcharts/issues/21776).
- Added tweening support for 4 and 8 digit hex colors.
- Use Point instances as context for tooltip and data label formatters and formats.
- Added support for individual whisker length for box plots and error bars. See [#21648](https://github.com/highcharts/highcharts/issues/21648).

## Upgrade notes
- All date and time strings are now by default rendered in the web page's default language as set in the `html.lang` attribute, or falls back to the browser default. Setting [lang.locale](https://api.highcharts.com/highcharts/lang.locale) to `en-GB` will restore the labels approximately as they were prior to v12. For exact backwards compatibility, set all the time format options (`xAxis.dateTimeLabelFormats`, `tooltip.dateTimeLabelFormats` etc) back to their v11 defaults in addition.
- The [time.getTimezoneOffset](https://api.highcharts.com/highcharts/time.getTimezoneOffset) function callback no longer works. Instead, use the [timezone](https://api.highcharts.com/highcharts/time.timezone) option.
- All time-related options in the [global](https://api.highcharts.com/highcharts/global) group were removed. Use the [time](https://api.highcharts.com/highcharts/time) options instead.
- The data handling of the Series class has been rewritten to use the DataTable class directly. As a consequence, the parallel arrays storing the series data are removed, and replaced by `Series.getColumn()`.
  - `Series.xData` is replaced by `Series.getColumn('x')`
  - `Series.yData` is replaced by `Series.getColumn('y')`
  - `Series.processedXData` is replaced by `Series.getColumn('x', true)`
  - `Series.processedYData` is replaced by `Series.getColumn('y', true)`
- The "Download PDF" menu item was removed from the default exporting menu, in preparation for a future update where exporting is done on the client side by default. The future update will require PDF download to either run via the export server like before, or to load a third party script. To re-enable the PDF download in the menu, add `downloadPDF` in the [contextButton.menuItems](https://api.highcharts.com/highcharts/exporting.buttons.contextButton.menuItems).
- The `HighchartModuleLoaded` window event is no longer supported as we moved to webpack builds with tree shaking capabilites. Instead, extensions must rely on events and wrapped methods.
- The `title.widthAdjust` option is removed. Instead, use [contextButton.buttonSpacing](https://api.highcharts.com/highcharts/exporting.buttons.contextButton.buttonSpacing) to make space for non-default context button.
- Titles and subtitles now have [adaptive alignment](https://www.highcharts.com/docs/chart-concepts/title-and-subtitle). To revert to the pre-v12 defaults, set `title.align` and `subtitle.align` to `center`, and `title.minScale` to 1.
- The [Point](https://api.highcharts.com/class-reference/Highcharts.Point) instances are now used as context for tooltip and data label formatters and format strings, instead of an abstract context object. In most cases this will cause no changes as the properties of the context object are now moved to the Point itself, but some changes may occur. Specifically the `{point.x}` key for points on a category axes will no longer return the category name. Instead, use `{category}`.

## Bug fixes
- Fixed [#21793](https://github.com/highcharts/highcharts/issues/21793), templating did not correctly parse sub expressions inside nested `if` conditions.
- Fixed [#22188](https://github.com/highcharts/highcharts/issues/22188), graphs were clipped at the left side when zooming on a series containing zones, and the x-axis was of type category.
- Fixed [#20550](https://github.com/highcharts/highcharts/issues/20550), [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) did not work with multiple stacks.
- Changed default [exporting.url](https://api.highcharts.com/highcharts/exporting.url) to a more stable server, dedicated to SVG export only.
- Fixed [#22187](https://github.com/highcharts/highcharts/issues/22187), word wrap failed for SVG when a word with markup fell at the breaking point.
- Fixed [#22100](https://github.com/highcharts/highcharts/issues/22100), pie data label was cut off in some cases when rendered at the bottom of the pie. Altered positioning logic by letting labels gravitate towards the sides when there is space available, which also leaves room for the pie to render larger in limited space.
- Fixed [#19335](https://github.com/highcharts/highcharts/issues/19335), accessibility focus border was incorrectly positioned in some edge cases.
- Fixed [#21863](https://github.com/highcharts/highcharts/issues/21863), a regression causing the Boost module to fail with treemap series.
- Fixed [#21890](https://github.com/highcharts/highcharts/issues/21890), `scrollablePlotArea` was not supporting [parallelCoordinates](https://api.highcharts.com/highcharts/chart.parallelCoordinates).
- Fixed [#21684](https://github.com/highcharts/highcharts/issues/21684), tooltip with [outside](https://api.highcharts.com/highcharts/tooltip.outside) did not receive css themes assigned to `container`.
- Fixed [#21924](https://github.com/highcharts/highcharts/issues/21924), custom sizes in marker states did not work.
- Fixed [#21098](https://github.com/highcharts/highcharts/issues/21098), corrections for ie11 compatibility fix.
- Fixed [#21136](https://github.com/highcharts/highcharts/issues/21136), pointer events were called on points outside of plot area with `scrollablePlotArea` enabled.
- Fixed [#21267](https://github.com/highcharts/highcharts/issues/21267), a regression causing elements to disappear when zooming on an X-range chart.
- Fixed [#21804](https://github.com/highcharts/highcharts/issues/21804), columns were crisped to full pixel width even when the `crisp` option was explicitly false.
- Fixed [#16931](https://github.com/highcharts/highcharts/issues/16931), errors in Chrome when modifying chart before printing the page.
- Fixed [#21745](https://github.com/highcharts/highcharts/issues/21745), click event was fired on drag for multiple charts.
- Fixed [#21530](https://github.com/highcharts/highcharts/issues/21530), tick values were padded onto user-defined category axes.
- Fixed [#18461](https://github.com/highcharts/highcharts/issues/18461), changes to `options3d` alpha and beta were not applied to pie body.
- Fixed [#21534](https://github.com/highcharts/highcharts/issues/21534), mouseover point event broke drilldown.
- Fixed [#20470](https://github.com/highcharts/highcharts/issues/20470), allow values from nested properties in exported data.
