# Changelog for Highcharts v2.3.5 (2012-12-19)
        
- Added [pie.startAngle](https://api.highcharts.com/highcharts/#plotOptions.pie.startAngle) option.
- Added a delay before hiding exporting menu to prevent the menu from hiding in IE when hovering over neighbour elements and button title. #1357.
- Implemented warning on unsorted data for line charts and stock charts. #725. Also throw a Highcharts error on unsorted column data, because the column distance and width logic relies on sorted data. Related to #987.
- Added line.step options: "left", "center", "right". Fixed issue with step in area ranges. #1330.
- Added a global lookup array, Highcharts.charts, holding all available chart instances in the page. This prevents issues with writing multiple charts to the same div.
- Implemented better animation for donuts. #779.
- Reorganized event assignment so that devices with touch support not only observe the touch events, but also the corresponding mouse events. This prepares for the new generation of browsers with both mouse and touch support. #1305.
- Prevented getTimeTicks from creating corrupted array. Related to #1301.
- Improved rendering speed of data labels by not adding a rectangle for labels without border or background.
- Better detection for repeating gradients. Instead for checking for the same object, the actual gradient definition is now used as the key. #1282.

## Bug fixes
- Fixed problem with gauge dial overlapping data label. #1403.
- Fixed issue with data labels of hidden series being visible after exporting from IE8. #1407.
- Fixed IE6 and IE7 issue with image symbol markers not always being displayed after page reload. #292.
- Fixed endless loop in Highstock JavaScript and SVG errors in all charts when setting a negative chart width. #1393.
- Fixed issue with wrong tooltip position in Android 4.0. #1385.
- Fixed issue with bottom checkboxes in a legend being hidden after cancelling legend scroll by resize.
- Fixed issue with series-level image markers not being visible in exported charts.
- Fixed issue with pie slices not being added to the legend after the first redraw. #1329.
- Fixed wrong Y axis extremes on stacked line series chart. #1376.
- Fixed issue with wrong placement of image backgrounds on labels, specifically image shapes in flag charts. #1378.
- Fixed problem with multiple buttons with menu items in exporting module.
- Fixed issue with visible borders in exported chart when borderWidth = 0 on column charts in Firefox. #1369.
- Fixed issue with tooltip remaining visible after hiding its series. #1361.
- Fixed issue with reflowing in IE < 9, as well as frozen pivot on resizing gauges in IE < 9. #1235.
- Fixed issue with backgrounds on multiple gauges within the same chart. #1244.
- Fixed JS error in IE8 when trying to assign a gradient color to image markers. #1336.
- Fixed issue with squished X axis labels on column charts with one single point. Now if the series only contains one value, only one tick is shown. #1337.
- Fixed issue with tick labels using useHTML and step being slightly visible. #1338.
- Fixed issue with legend items not responding to mouse interaction when legend.useHTML is true. Fixed positioning of legend items in Chrome when legend.useHTML is true. #1249.
- Fixed issue with wrong positioning of bars in a bar chart when grouping was set to false. #1251.
- Fixed issue with useHTML, fixed width and word wrapping in Firefox. #1254.
- Fixed issue with legend checkbox position not being updated in navigatable legends. #1253.
- Fixed issue with wrong placement of minor grid lines on datetime axes. #1314.
- Fixed issue with Highcharts.dateFormat only replacing the first occurence of a pattern. #953.
- Fixed issue with wrong dial rotation in angular gauges when used with logarithmic axes.
- Fixed memory leaks in IE7 releated to SVGRenderer.label and MooTools. Refering to #1298.
- Fixed issue with blinking column animation on extremely large columns. #1303.
- Fixed issue with data label alignment not being updated after point update. #1306.
- Fixed broken height detection of rotated labels in IE9. #1307.
- Fixed line graph tracker objects so that the stroke-linejoin is round. This ensures better tracking around spikes in the data. #1225.
- Fixed issue with placement of data labels on a column chart with reversed Y axis. #1308.
- Fixed issue with visible gray marker objects appearing after Batik export from IE10.
- Fixed error on exporting an empty chart due to labels with y attribute of NaN. #1300.
- Fixed issue with setting tooltip.valueDecimals to 0. #1248.
- Fixed JavaScript error on redrawing chart after series removal in IE < 9. #1258.
- Fixed issue where the upper data label of a range point wasn't destroyed on Series.setData(). #1286.