# Changelog for Highcharts v3.0.3 (2013-07-31)
        
- Added automatic stagger lines for colliding labels on horizontal axis.
- Added support for automatic text wrapping in long title names. Closes #776.
- Added new option, [legend.itemDistance](https://api.highcharts.com#legend.itemDistance), to allow control over the distance between items of a horizontally laid out legend. Closes #832.
- Added context and event information to click handlers on touch devices. Closes #1830.
- Added useHTML option for plot line and plot band labels. Closes #1916.
- Added support for multidimensional series (arearange, ohlc, box plot etc.) in data module.
- Added automatic default alignment of axis labels based on which side of the chart and the label's rotation.
- Added automatic line-wrap of titles and subtitles if the text exceeds the chart width. This change includes changing the default Y position of the subtitle to allow it to depend on the title height.
- Increased performance of Series.addPoint on large series by preventing looping over all data points on each call. Closes #1937.

## Bug fixes
- Fixed #2017 where the browser would freeze when xAxis.min equals xAxis.max on a datetime X axis.
- Fixed legend box size browser issue.
- Worked around issue in Chrome 28 where numberFormatting would round all values to whole numbers after running for a while. Closes #2043. Closes #2052.
- Fixed issue with point.name being applied to the wrong category label. Closes #2046.
- Optimized merge function by moving a check out of the loop. Closes #2045.
- Fixed issue with wrong calculation of areas when a negative color was used on an inverted chart with non-zero threshold. Closes #2011.
- Fixed issue in Highcharts 3.0.2 where data labels for null points were rendered as 0. Closes #1997.
- Fixed issue with click events on columns not firing on touch devices until the second touch. Closes #1551.
- Fixed issue with mouse and tooltip offset inside frameset when running IE10 in compatibility mode. Simplified mouse position detection. Closes #2005.
- Fixed issue with percentage stacked area and missing values. Closes #1991.
- Fixed issue with unexact position of columns where minPointLength applies. Closes #1166.
- Fixed problem with setting area series fillOpacity to 0. Closes #1983.
- Fixed issue with export menu displaying outside the chart at the top of the button. Closes #1985.
- Fixed issue with double xmlns attributes created in IE9 and IE10. Closes #1978.
- Fixed issue with pie slices animating from center on first call to Point.update. Closes #959.
- Fixed issue with updating shadow positions on bubbles. Closes #1977.
- Disallow JavaScript execution from formatted category labels.
- Fixed issue with percentages not being available for pie chart legend. Closes #897.
- Fixed issue with visible:false not taking effect on pie chart data labels. Closes #876.
- Fixed issue with updating an element's dashstyle programmatically. Closes #874.
- Fixed issue with stack labels not appearing in other series types than column. Closes #1383.
- Fix for error while converting to SVG file in phantomjs, missing character in XML.
- Added event to hide the tooltip on touch devices when touching outside the plot area. Closes #1203.
- Fixed issue with stacked columns within a single series. Closes #1959.
- Fixed issue with useHTML labels not cleaning up their parents when destroyed. This would leave a lot of empty divs inside the container after updating for example axes. Closes #1960.
- Fix for error while downloading SVG files, missing character in XML doctype.
- Fixed issue with point markers not being aligned to columns. Closes #1843.
- Fixed PDF cropped and split on 2 pages issue #1957.
- Fixed issue with IE8 and exporting with old look. Closes #1964.
- Fixed issue with no legend symbol on areaspline series when line and markers were hidden. It now uses the rectangular legend symbol like regular area series. Closes #602.
- Fixed issue with area legend taking the marker fill color instead of the area fill color when different. Closes #585.
- Fixed issue with legend box not reserving space for legend title. Closes #1717.
- Fixed issue where switching from log to linear scale caused the threshold of columns to become lower than zero. Closes #1791.
- Fixed issue with legend symbols not being centered in text when font size increased. Closes #1804.
- Fixed tooltip order and naming of quartiles in box plot.
- Fixed issue with rotated labels along a vertical axis becoming wrongly positioned based on bounding box. Closes #1951.
- Better detection for showing or hiding the data labels based on whether the entire bounding box is inside the plot area. Closes #1788.
- Fixed issue with dynamically modified data being lost after Series.update. Closes #1780.
- PhantomJS JavaScript files are automatically unzipped to java.io.tmpdir.
- Fixed issue where calling Point.select(true) on a pie slice would toggle it, not select it. Closes #1823.
- Fixed issue with removing plot band or line and reflecting it in export. Closes #1114.
- Fixed issue with adding X axis dynamically. Closes #1827.
- Fixed funnel chart issues with center Y not taking effect, and points disappearing when neckHeight is equal height. Closes #1866.
- Fixed issue when using rotation on a particular point's data label, the next point's data label would be rotated. Closes #1883.
- Fixed issues with legend items not reflecting updates to pie slices. Closes #1831. Closes #1885.
- Fixed issue with wrong alignment of labels on the X axis of a rotated polar chart. Closes #1942.
- Fixed issue with too tight ticks on X axis on column charts with only a few columns. Closes #1943.
- Fixed issue with bubble series not working at all when number of points exceed the turboThreshold. Removed the turboThreshold option for bubble series. Closes #1898.
- Fixed issue with spline animation of lower part when negativeColor is used and running addPoint. Closes #1899.
- Moved the warning on unsorted data to catch unsorted data in the middle of the data set in addition to the first two values. Closes #1900.
- Fixed issue with X axis not redrawing after Point.update. Closes #1906.
- Fixed issue with tooltips not accounting for the startAngle of a polar chart. Fixed issue with tooltips not being wrapped around from the last point to the first point at the top of a polar chart. Closes #1915. Closes #1469.
- Fixed issue with Safari crashing when displaying tooltips with nested HTML tags. Closes #1596.
- Fixed issue with negativeColor and logarithmic Y axis. Closes #1726.
- Fixed issue with negativeFillColor not taking effect unless a negativeColor is also set. Closes #1907.
- Fixed issue with multiple class names added to tracker objects. Related to #1918.
- Fixed wrong position of dials in IE7 and IE8 Quirks mode. Closes #1873.
- Fixed issue with inconsistent xAxis label width on bar charts. Closes #1931.
- Fixed issue with click events not being handled on flag series in IE9 and IE10. Fixed support for hovering stacked flags in old IE. Closes #1924.
- Fixed regression with wrong higher path on arearange series on inverted chart. Closes #1930.
- Fixed position of rotated X axis labels to prevent overlapping with the element below. Closes #1764.
- Fixed JS error on setting new data on initially empty series. Closes #1920.
- Fixed issue with datetime axes not using intervals greater than 10 years. Closes #1913.