# Changelog for Highcharts v3.0.6 (2013-10-04)
        
- Added new option, chart.spacing, to set spacing as an array.
- Added round linejoins and linecaps to line graphs for better look in prints.
- Added support for negative values in stacked percentage columns. Closes #2197.
- Added new option to pie charts, endAngle, to allow semi-circle donuts and pies.
- Added experimental support for axis.labels.ellipsis. Not implemented for VML renderer.
- Adapted Java exporting server to PhantomJS saving files locally.
- PhantomJS running as server can save files to filesystem, closes #2137.
- Fixed issue with too high axis max tick on very small charts where the height of the plot area was much smaller than the tickPixelInterval setting.
- Implemented Async download from export server.
- Added CORS filter for Cross-Origin requests to export server.
- Adapted Java exporting server to PhantomJS saving files locally.
- Add event handler to close context menu from touching outside the menu. Improves user experience on touch devices. Closes #2258.
- Forced disabling of startOnTick and endOnTick when navigator is enabled in Highstock. Closes #1090.
- Exposing the reflow method on chart objects.
- Added no-data-to-display plugin.
- Worked around bug in IE11 with rendering text in horizontal legends. Closes #2030.
- Added new option, dataLabel.overflow: 'justify'. Closes #1789, #1859, #1962, #1984 and #2190.

## Bug fixes
- Fixed issue with scatter series not displaying in polar charts. Closes #2060.
- Fixed issue on touch devices with click events not firing on series, points or chart when chart.zoomType was set. Closes #2275.
- Fixed regression issue with slow running updates on gauges. Closes #2320.
- Fixed regression with vertical crosshair not working in Highstock with series compare. Closes #2316.
- Fixed issue with hide/show series in some versions of Android. Closes #2269.
- Fixed error message in PHP/Batik exporting stack when called without posting width. Closes #2303.
- Worked around InkScape bug where the hidden empty tooltip would display as a square in exported SVG. Closes #2301.
- Fixed issue with updating min and max using Axis.update() after running setExtremes. Closes #2306.
- Fixed issue with bubbles not resizing in IE8. Closes #2294.
- Fixed issue with unsorted data labels for funnels. Closes #2289.
- Fixed issue with JS errors in IE8 when trying to animate a rotated data label. Closes #1821.
- Fixed issue with disabling data label for a specific point not taking effect. Closes #2282.
- Fixed issue with Highcharts error 19 triggering with a hidden or very small chart. Closes #2272.
- Fixed issue with exporting button's menus being shared between multiple buttons. Closes #1908.
- Fixed issue with bubbles and other marker points not taking the "color" property of the point. Closes #2219.
- Fixed compatibility issue with the Standalone Framework and Dojo. Closes #2268.
- Fixed issue with updating to line series when starting with a spline. Closes #2270.
- Fixed issue in gauges with ticks disappearing or being badly laid out after resizing. Closes #1262.
- Fixed issue with Standalone Framework in legacy IE where click event wouldn't work on line series, and hovering didn't preserve the state of the tooltip. Closes #2265.
- Fixed JS error on adding VML styles in old IE in pages with more than 32 style sheets. Closes #2153.
- Fixed issue with waterfall columns starting at the wrong place with certain values on the Y axis. Closes #2241.
- Fixed issue with stacks not being cleared after updating a series. Closes #2229.
- Fixed issue with error number 19 firing on stock charts with ordinal axis when not needed. Closes #2228.
- Fixed positioning problem with tooltips on flags. Closes #2211.
- Fixed issue with addPoint() on waterfall charts. Closes #2209.
- Fixed issue with wrong animation between lines of different length. Related to #1325 and #1386.
- Fixed issue when having no data in stacking chart. Closes #2207.
- Fixed issue with removing points in funnel charts. Closes #2206.
- Fixed issue with Point.update removing the selected state when applied with an object configuration. Closes #1909.
- Fixed issue where running addPoint with an X value not being able to insert the point into the middle of a sorted series. Closes #1109.
- Fixed issue with percentage stacked area series adding up negative values incorrectly. Closes #2197.
- Fixed issue with overlapping X axis labels and maxStaggerLines not taking effect on dynamically added series. Closes #2186.
- Fixed error on redrawing chart after applying a plot line with zero width. Closes #2189.
- Fixed issue with data labels of hidden series attracting mouseover and tooltips in IE10. Closes #2185.
- Fixed issue with connectNulls not taking effect on stacked areas. Closes #1836.
- Fixed regression where the lower stacked series in an area stack would not display. Closes #2181.