# Changelog for Highcharts v3.0.8 (2014-01-09)
        
- Export: Streamlined and removed unnecessary properties in maven pom.xml.
- Export: Cleaning up overlap in maven dependencies for java export server.
- Added handling of white-space: nowrap in styles for SVG text.
- Implemented logic that removes overlapping axis labels just before they are rendered.

## Bug fixes
- Fixed issue with unexpected arc rendering in VML. Closes #168.
- Added multitouch support for IE10/11. Closes #2536.
- Added default date format for the headerFormatter. Closes #2546.
- Fixed issue with categorized Y axis overflowing the plot area because category padding weren't applied. Closes #1784.
- Fixed issue with negative color being clipped in a series with all negative values.
- Optimized performance by caching results for getBBox for numbers, since numbers are monospaced and the same bounding box applies to any number of the same character length and the same font family and font size. Also, don't delete cached bounding box on word wrap when there is only one word. These two optimizations improved rendering times by 15% on Chrome and Firefox using our benchmark tests. Relates to #2525.
- Fixed JS errors in IE11 workaround when destroying a chart in the same thread as creating it. Closes #2030.
- Prevented memory build-up in datetime axes by avoiding unnecessary use of the Axis.names array for categories. Closes #2523.
- Fixed issue with hidden pie slices affecting the positions of data labels. Closes #2510.
- Prevent timeout when calling chart.reflow as an API call. Closes #2224.
- Fixed issue with disappearing data labels in gauges when center is outside plot area. Closes #2415.
- Fixed issue with clipped chart when resizing down. Closes #2503.
- Fixed typo in series sorting causing series to change order when updating series type in IE9. Closes #2501.
- Fixed issue with point state marker graphic staying in its previous position after a zoom operation on mouse or touch devices. Closes #2500.
- Fixed issue on iOS where selection of columns and pie slices needed two touches except on the very first run. Closes #2499.
- Fixed JS errors on empty series on secondary axis when tickPositions were defined. Closes #2482.
- Added formattributes to exporting to allow setting custom attributes.
- Removed line running setting event.returnValue, which causes a warning in Chrome. Closes #2251.
- Fixed a couple of minor issues related to legend navigation.
- Fixed regression on running Point.update with null value. Closes #2481.
- Export: Refined code on waiting for images loaded.
- Export: Missing images fallback gracefully, closes #2474.
- Fixed regression with stack order not being affected by series.index. Closes #2456.
- Fixed issue with bubble chart not displaying when displayNegative was false.
- Fixed issue with data label styles not updating from Point.update. Closes #2468.
- Improved setOptions by copying new objects into existing instead of creating new defaultOptions structure. Improves performance and keeps internal pointers. Closes #2469.
- Fixed SVG errors on exporting SVG from IE8, causing Batik not to render the SVG. Closes #2463.
- Fixed JavaScript error when firing a series click event in IE8 using the Standalone Framework. Closes #2465.
- Removed thousands separators from numbers below 10,000 in the default X axis label formatter. This prevents commas to be inserted in years when applied to a linear axis. Closes #2466.
- Data module: Update itemDelimiter option to default to tab character if a tab is found within the CSV string. This makes CSV parsing work with content copied directly from Excel.
- Fixed issue with clipped legend items when navigation is enabled. Closes #2098.
- Fixed issue with document events set in exporting not being destroyed when destroying chart. Closes #2407.
- Fixed issue with tooltip options not taking effect on certain series types where the same options were defined in series specific defaults. Closes #907.
- Fixed issue with markers on inverted charts. Closes #2450.
- Fixed issue with shared tooltip showing wrong category when pointPlacement was used. Closes #2434.
- Performance improvement by not listening to document mousemove when the tooltip is hidden.
- Added symbolHeight and symbolRadius options for legend.
- Fixed issue with orphaned stack labels after Series.destroy and Series.update. Closes #2440.
- Fixed issue with updating the visibility of a pie slice causing it to go invisible. Closes #2430.
- Added new option, [global.timezoneOffset](https://api.highcharts.com/#global.timezoneOffset), to allow setting which timezone the data is displayed in even though the input data is defined as UTC.
- Fixed bad positioning of rotated elements when useHTML was true. Closes #2404.
- Added error message on trying to add an object literal point configuration on a series with more data points than the turboThreshold.
- Fixed issue with flags on the last point dropping down to the X axis when the main series enters data grouping. Closes #2374.
- Fixed regression where legend would disappear when the linkedTo option was set to null. Closes #2414.
- Fixed regression causing JS errors after updating an axis title when useHTML is set. Closes #2402.
- Fixed issue with NaN tick positions being applied to empty axis, causing wrong number of ticks in chart with multiple axes. Closes #1741.
- Export: Beans from export-convert-module are now configurable from the export-web-module.