# Changelog for Highcharts v4.0.3 (2014-07-03)
        
- Added 3d options [edgeColor](https://api.highcharts.com#plotOptions.column.edgeColor) and [edgeWidth](https:/api.highcharts.com#plotOptions.column.edgeWidth) to distinguish from borders that have different defaults.
- Added option, [chart.panKey](https://api.highcharts.com#chart.panKey), to allow panning and zooming on the same chart. The chart can now be configured so the user can pan by holding down the shift key while dragging.
- Added features [zMin](https://api.highcharts.com#plotOptions.bubble.zMin) and [zMax](https://api.highcharts.com#plotOptions.bubble.zMax) for bubble series, to set the Z value corresponding to `minSize` and `maxSize` independently from the data.
- Changed default top position for loading label to 45%, which results in a vertically centered label.
- Better handling of data label heights on pie charts, related to #2630.
- Better handling of dynamic font sizes. Adjust tooltip text-wrapping. Apply dynamic font size (em) on line breaks. Fixed placement of title and axis labels when using ems for font size. Added support for em font-size in legend.itemStyle.

## Bug fixes
- Fixed #2251, a regression since 3.0.8 causing text and graphic elements to become selected while zooming in old IE.
- Fixed #3195 where a short axis with startOnTick and endOnTick set to false would display no ticks at all.
- Fixed #2694 causing columns to overlap by one pixel in some cases when pointPadding is 0.
- Fixed #2227, waterfall breaking with more than one intermediate sum.
- Fixed #3163, pie chart data labels displaying outside plot area.
- Fixed #1991, a regression causing area stacks with null or missing values to draw incorrectly.
- Fixed #3158 causing wrong line wraps on text containing markup.
- Fixed #3151, waterfall columns not displaying a border when the rendered height was 0.
- Downloadbuilder missing metatags in SVG, added filterset, fixes #3106.
- Fixed #3072 causing unexpected borders after hover on column series when borderWidth was 0.
- Fixed #3132 causing wrong line breaks in SVG text (pseudo HTML) containing markup.
- Enabled mouse tracking on data labels for some series types where it had been mistakenly disabled.
- Fixed #2697, JavaScript error in IE11 on destroying a chart containing useHTML elements after the chart container has first been emptied.
- Fixed #3126, waterfall graph getting wider on hover. Introduced new options, `lineWidthPlus`, `radiusPlus` for hover state of graphs and markers.
- Fixed #3116, halo failing to animate when a point was updated to a new position. Removed redundant pointer.reset call on Axis.redraw because Chart.redraw also calls the same method.
- Fixed #3113, roundoff error throwing off calculations of extremes on log axis.
- Fixed #3104, touch panning not being able to pan outside the data range even if the axis min and max options were outside the range.
- Fixed #3098, plot area size of a pie chart not being recalculated after the legend size changed.
- Fixed #3090 causing default 3d options not to be interpreted correctly.
- Fixed #3094 causing series Z index to change after Series.update.
- Fixed regression issue #3095, semi-transparent fills coming out as black in exports created by Batik.
- Fixed #3082, positioning of 3d pie datalabels.
- Fixed #3080 causing JS error on low chart due to negative height of the legend clip rectangle.
- Fixed #3051 causing wrong Z indexes for slices in 3d pie charts.
- Fixed #3075 causing touch panning on a categorized axis to alter range.
- Fixed #3039, series options was not read for 3D.
- Fixed #2893 causing heatmap point colors not to update after updating the color axis coloring.
- Fixed #1080, loading text not reflowing to changed chart size.
- Fixed #3056 with tooltip chevron not pointing exactly on the right point of the graph when animating between close positions.
- Fixed #3044 causing JS errors in some cases when axis label formatter returned null or undefined. Closes #3050.
- Fixed #3053 causing series to be cropped too tight on logarithmic X axis when the number of points exceeded the crop threshold.
- Fixed #2240 causing the point mouse out event not to fire when the tooltip is shared.
- Fixed #2997, solidgauge issue with points past ±360° or below `yAxis.min`.
- Fixed #3028 causing the last series to become unlinked when calling `Series.update` on several linked series in succession.
- Fixed #3027 causing truncation of axis labels when the axis title offset is set and the axis title is shorter than the labels.
- Fixed #3023 causing defered data labels to show even if series was hidden in the meantime while animating.
- Fixed #3003 causing rotated data labels to be misaligned after redraw when using Standalone Framework.
- Fixed #3017 causing centering of data labels on inverted range series not to work.
- Fixed #3007, with halo showing on invisible points in pies.
- Fixed #3016 causing halo on sliced pie series to diplay incorrectly.
- Fixed #3000, labels wrongly aligned on plot lines with multiple axes.
- Fixed #3014 causing wrong tooltip position in waterfall charts in Highcharts 4.
- Fixed #3006, prevent null and 0 points from rendering in 3D Pies.
- Fixed #2982 by returning the added plot line or plot band object after `Axis.addPlotLine` or `Axis.addPlotBand`.
- Fixed #2977, set mimimum view point distance for 3D.
- Fixed #2975 with clipping not being updated on column series and derived series types after chart resize.
- Fixed #2968, 3d columns not drawn correctly when equal to max.
- Fixed #2963 where columns were badly drawn in Chrome due to a rendering bug.
- Fixed #2962 causing data labels on gauges not to display unless defer is set to true.
- Fixed #2954 that caused invalid SVG attributes on animating in and out grid lines when running older jQuery versions or the Standalone Framework.