# Changelog for Highcharts v4.0.4 (2014-09-02)
        
- Added more date parsing logic to the data module. Now integrates with Date.js, and uses Date.parse. Tries to parse all dates, but falls back to categories if dates are not sorted (which may be a sign that parsing went wrong).
- Added support for setting marker image dimensions. Closes #1807. Closes #1817.
- Added a better default value for xAxis.allowDecimals. Don't allow decimals in X value ranges that look like years. Closes #3363.
- Added warning on trying to plot negative points on a logarithmic axis.
- Allow changing "Date" class used to support other calendars. Added new option global.Date.
- Allow overriding Highcharts.numberFormat from the outside. Closes #3284.
- Made point.click event work in combination with drilldown charts.

## Bug fixes
- Fixed #3381 3D pies, wrong z index applied to sides.
- Fixed #3279, column z issues in 3d.
- Fixed #3397, footerFormat does not replace variables.
- Speed optimization of Series.setData, related to #3260.
- Fixed #2909, a regression causing chart click event not to fire when zoom enabled on touch devices.
- Fixed #3334, missing animations in 3d pies.
- Fixed issue causing markers to show even on dense line series, in spite of new logic in 4.x where it should depend on series density.
- Fixed #3202, tick marks being drawn in unwanted positions when tickInterval was set on categorized axis.
- Fixed #424, wrong tooltip position for column series in a pane position.
- Fixed #3352, JavaScript errors on clicking category labels on async drilldown.
- Fixed #3344, drilldown axis label style inconsistent after redraw.
- Fixed #3353, wrong axis minimum and maximum on thresholded series when switching from linear to logarithmic axes type.
- Fixed #3342, memory leaks in jQuery 2.x when repeatedly reinstanciating charts or destroying and recreating renderer primitives.
- Fixed memory leak on addPoint caused by adding empty names to the Axis.names lookup table.
- Fixed #3328, 3D Columns and null values.
- Fixes #3317, extra tick added when there are only two ticks (start and end).
- Fixed #3315 by disallowing duplicate ids in drilldown.
- Fixed #3182, three level drilldown broken when drilling up and down again on the same series.
- Fixed #3276 with HTML markup in element titles when a label is shortened by ellipsis.
- Fixed #3088, tooltip blocking new mouse interaction after hiding when useHTML is true.
- Fixed #3285, funnel and pyramid center option not working for vertical dimension.
- Fixed #3300 where data labels would remain semi-transparent when chart updated in the middle of labels fading in.
- Fixed #3295, labels do not render 0 as value.
- Fixed #3282, plotBorder width changed sign, causing a strange animation.
- Fixed #3245, waterfall series failed when first element was Sum or IntermediateSum.