# Changelog for Highcharts v4.1.0 (2015-02-16)
        
- Added [polygon](https://api.highcharts.com/#plotOptions.polygon) series type.
- Added `e.category` event argument in drilldown events to make it clear when a category is clicked. Related to #3771.
- Added new option to the data module, [firstRowAsNames](https://api.highcharts.com/#data.firstRowAsNames).
- Added new option, [pointIntervalUnit](https://api.highcharts.com/#plotOptions.series.pointIntervalUnit), in order to allow months and years as point intervals. Closes #3329.
- Added [beforePrint](https://api.highcharts.com/#chart.events.beforePrint) and [afterPrint](https://api.highcharts.com/#chart.events.afterPrint) events. Related to #2284 and #3729.
- Added new method, [Series.removePoint](https://api.highcharts.com/#Series.removePoint), to allow removing points that are not instanciated on demand.
- Added new option, global.getTimezoneOffset, to allow integration with third party timezone libraries like moment-timezone.js.
- Added new Axis option, [tickAmount](https://api.highcharts.com/#yAxis.tickAmount). Refactored alignTicks on multi-axis charts to first compute a [tickAmount](https://api.highcharts.com/#yAxis.tickAmount), then make all axes comply with that.
- Added new Axis option, [autoRotation](https://api.highcharts.com/#xAxis.labels.autoRotation) as an array of possible values.
- Added new callback option, [tooltip.pointFormatter](https://api.highcharts.com/#tooltip.pointFormatter).
- Added polar support for arearange. Issue #3419.
- In solid gauges, added support for initial animation as well as setting animation object for updates. Closes #3135.
- Made the entire numberFormat method settable and wrappable from the outside.
- Made tooltip.followTouchMove true by default, and allowed page scroll at the same time.
- Implemented support for "contrast" color setting in data labels. When the data label is inside a shape (like a column), this will ensure the best readability.
- On category axes, let the crosshair width cover the whole category like a band.
- Refactored zIndex handling on SVGElements so that the zIndex can also be modified after the element is first added.
- Changed the Axis.tickPositioner callback so that the default tick positioning logic runs first, to allow modification in the tick positioner instead of creating positions from scratch. Closes #3538.
- Made the legend draw below or above the plot area in cases where it is placed in a corner and the layout is horizontal.
- Implemented algorithm for setting precise tooltip xDateFormat when needed, but general format like year, month, day etc. when the time falls on midnight and the closest point range dictates it. Related to #3329.
- New default behaviour for the xAxis.minTickInterval option on datetime axis. It now goes to the closest point range by default.
- Implemented silent degradation instead of error 19 when user options dictate too many ticks on an axis.
- Removed overflow:justify logic. Instead, move labels and add ellipsis in case of overflow.
- Export server: Adapted to PhantomJS 2.
- Export server: Implemented XSS filter.
- Fixed error on applying stacking to area range series.
- Partly fixed #3506, overlapping axis labels on polar chart.
- Fixed waterfall issue where the upColor stayed after updating point to negative. Related to #3710.
- Don't allow decimals on yearly X axis.

## Bug fixes
- Fixed #3724, JS error on preventing the selection event and running setExtremes immediately.
- Fixed #3728, Point.update not updating category name.
- Fixed #3743, minor ticks rendered outside plot area.
- Fixed #3778, redundant legend paging visible after redraw.
- Fixed #3197, drilldown with hidden series.
- Fixed #3719, updating areaspline to area failed.
- Fixed #3703, show no-data message on hidden series also.
- Fixed #3679, no-data label not realigning after showing hidden container.
- Fixed #3710, update point did not update sum in waterfalls.
- Fixed #3712, checkboxClick not handled for pie charts.
- Fixed #3708, color disappearing on redraw of solid gauge.
- Fixed #3702, JS error when running setData on a hidden series.
- Fixed #3670, funnel ignored point specific border settings on init.
- Fixed #3648, data label posision for column incorrect when using custom positioned Y axis in inverted chart.
- Fixed #3654, millisecond ticks not placed correctly.
- Fixed #3652, minor grid lines sometimes rendering outside the plot area to the right.
- Fixed #3201, crashes when zooming too far in on a dashed series.
- Fixed data module issue with blank chart when using forced categories with data longer than turboThreshold.
- Fixed #3635, markers overlapping in cases where they should not, according to the default behaviour.
- Fixed #2361, plot bands disappearing under certain conditions when zooming in so that parts are clipped.
- Fixed #3636, negative colors not applied on hover.
- Fixed #3623, negative values in pies causing bad drawing after running setData.
- Fixed #3575, huge columns not rendering on Chrome.
- Fixed #3608, reversed Y axis in gauges causing arcs to be drawn inside out.
- Fixed #3600, errors raised in modules when a chart was destroyed in its own callback.
- Fixed #3346, tooltip failed for two Y axes side by side.
- Fixed #3579, mixed up levels in multidimensional drilldown.
- Fixed #3569, reset zoom button disappeared after multiple zoom operations in empty area.
- Fixed #3390, single heatmap point getting huge size and causing rendering defects. Better axis metrics for single points. Closes #2515.
- Fixed #3544, drilling up failed when top series data was added dynamically.
- Fixed #3536, implemented error message on wrong color definitions in heat maps.
- Fixed #3525, error 12 in master-detail demo.
- Fixed #3295 and #3514 label box not rendered correctly with 0 values.
- Fixed #3507, fixed width tooltip with a single word on the last line was clipped horizontally.
- Fixed #3501, long axis labels taking up too much space instead of wrapping in drilldown charts.
- Fixed #3500, monthly and yearly X axis ticks having the wrong distribution when using timezoneOffset.
- Fixed #3449, export menu not working on touch devices when zoomType was set.
- Fixed #3391, halo not hidden on hiding a pie slice from legend.
- Fixed #2889, tooltip not displayed on line series when followPointer was true. Closes #3258.
- Fixed #3176, updating gauge axis caused background to disappear.
- Fixed #2919, errors and wrong behaviours on multi-level drilldown.
- Fixed #3445, pie charts showing wrong bullet color in tooltip.
- Fixed #2919, errors on drilldown with multiple axes.
- Fixed #2912, JS error on drawing hidden waterfall.
- Fixed #3437, data module failing with numeric data in first column.
- Fixed #3436 causing round linecaps on median lines in box plots. Reverted fix for #1638, a workaround for a Firefox bug regarding linecaps. Newer Firefox versions don't have the bug.
- Fixed #3431, regression causing error 16 not to be triggered.
- Fixed #3434, error 10 throwed with null values on logarithmic axis.
- Fixed #3380, a regression causing Series.update not to honour updated zIndex.
- Fixed #3240, 3d pie labels with 0 values.
- Fixed #3418, wrong default tooltip header date format when passing points every two days, two months etc.
- Fixed #3416, broken tooltip on colorAxis.
- Fixed #3152, tooltip didn't display on the far left of a zoomed axis with categories.
- Fixed #3382, line series disappering when a negativeColor was applied and the threshold was way beyond the chart.
- Fixed #3411, align ticks fails without ticks.
- Fixed #3402, redundant halo on heatmap.
- Fixed #3404, regression causing canvas heatmap to white out.
- Fixed #3402, issue with updating bar to pie.
- Fixed #3389, JS error when drilling up multi-level too quickly.