# Changelog for Highcharts v4.1.8 (2015-08-20)
        
- Added experimental support for using HTML in exported charts through the [exporting.allowHTML option](https://api.highcharts.com/#exporting.allowHTML). Discussed in #2473.
- Added new option, [maxPointWidth](https://api.highcharts.com/highcharts#plotOptions.column.maxPointWidth), to the column chart type and its derivatives.
- Add `%k`, hours with no padding, in dateFormat.
- Don't cache undefined bounding box key. Closes #4328.

## Bug fixes
- Fixed #4448, which causes duplicated event calls for column series.
- Fixed #1498, minor ticks were missing when using column series.
- Fixed #1655, where setExtremes event could be called with undefined extremes.
- Fixed #2775, click on custom button propagated and caused JS errors when destroying chart.
- Fixed #3379, minPadding and maxPadding was wrong on color axis.
- Fixed #3737, points within a group were not reversed in a reversed bar chart X axis.
- Fixed #3879, where linked series didn't inherit initial visibility from a parent.
- Fixed #3909, HTML data label was invisible after drilling up.
- Fixed #4149, tooltip went off plot area when data was clipped.
- Fixed #4189, wrong position of the legend in IE7.
- Fixed #4219, enconding problem with ellipsis. Better fix for #4079.
- Fixed #4246, pie slices with null values should not be rendered.
- Fixed #4313, setting one of the extremes removed both, min and max, axis paddings for bubble series.
- Fixed #4320, stack items building up and creating memory leak when adding and removing points.
- Fixed #4333, data label overlapping detection was too aggressive. Don't handle padding when the label doesn't have a border or background.
- Fixed #4339, touch-dragging in IE11 on a zoom enabled chart caused JS errors.
- Fixed #4343, axis lines missing when 3D was loaded.
- Fixed #4347, legend item click of heatmap with data classes should hide items.
- Fixed #4349, updating point.x prevented point from being hidden from legend.
- Fixed #4350, pie chart failing with StockChart constructor.
- Fixed #4356, pointBreak wasn't called for values below the threshold.
- Fixed #4356, series with null threshold now calls breakPoint correctly.
- Fixed #4359, drilldown pie selected slices had wrong color.
- Fixed #4360, float error on logarithmic axis label.
- Fixed #4364, chart click event fired when clicking menu items in the export menu.
- Fixed #4365, pie chart connectors were not hidden when data labels used HTML and hiding the series.
- Fixed #4371, where negative Axis offset miscalculated clip-path for series.
- Fixed #4390, JS error in some cases on updating a series with no data.
- Fixed #4396, different minSize and maxSize per separate series didn't work.
- Fixed #4401, better handling categories based on a point.name.
- Fixed #4410, a regression causing incorrect mouseover events in column charts.
- Fixed #4411, setting axis.labels.step to 1 didn't result in 1:1 labels.
- Fixed #4420, generic X axis gridline width with 3d columns.
- Fixed #4421, overlapping upper data labels on arearange series.
- Fixed #4430, point color was not set on positive points when negativeColor was set.
- Fixed #4434, regression causing failure with reversed solid gauge.
- Fixed #4443, auto rotation was not reset after widening chart when labels used HTML.
- Fixed #4449, a regression causing wrong alignment on legend items when rtl was combined with useHTML.
- Fixed #4477, too dense ticks when setting staggerLines, caused browser crash.
- Fixed #4313, setting one of the extremes removed both, min and max, paddings.
- Fixed #4351, setSize with standalone adapter didn't resize inner container.
- Fixed animation on updating map colors.
- Fixed issue with displayNegative not working with all data. Closes #4419.
- Fixed issue with pie and data labels producing JS error in IE6.
- Fixed issue with updating mapbubble point to null.
- Fixed regression with JS error on updating pie slice value to null.
- Improve logic for pointBreaks, touch #4356.
- Partial fix for #3861, bubble series not working with logarithmic axes. It now displays, but the bubbles are clipped unless the user sets a padding.