# Changelog for Highcharts v4.1.9 (2015-10-07)
        
- Added new option, [axis.visible](https://api.highcharts.com/highcharts#xAxis.visible).
- Added new option, [bubble.sizeByAbsoluteValue](https://api.highcharts.com/highcharts#plotOptions.bubble.sizeByAbsoluteValue), to allow negative bubbles sizes to be based on the absolute value rather than a scalar difference from smallest to greatest. Closes #4498.
- Added new series option, [softThreshold](https://api.highcharts.com/highcharts#plotOptions.series.softThreshold), to prevent showing subzero axis ticks for line series that consist of positive data only.
- Added support for `legendType: 'point'` on more series types than just pie and its derivatives.

## Bug fixes
- Fixed #2473, allowHTML should not affect the `forExport` flag.
- Fixed #2711, set proper order of data labels inside columns.
- Fixed #2854, SVG images in symbol URL's did not display in IE11.
- Fixed #3529, selected point changed color after updating.
- Fixed #3542, tooltip with useHTML did not fade out smoothly.
- Fixed #3632, pie inner size shouldn't be allowed to be greater than outer size.
- Fixed #3636, `negativeColor` wasn't set for marker on hover.
- Fixed #3801, pie chart radial gradient position did not update on chart resize.
- Fixed #3971, X axis label step was not honoured when rotation was set.
- Fixed #4136, treemap did not export correctly after drillToNode.
- Fixed #4298, treemap did not update axis extremes after updated data.
- Fixed #4431, tooltip was broken when changing from column series to a different type.
- Fixed #4442, `alignTicks` forced axes to align, even when only one of them contained data.
- Fixed #4465, tooltip disappeared on point when `stickyTracking` was false.
- Fixed #4482, line disappeared during animation when series.step was enabled.
- Fixed #4485, ticks were added inside axis break on datetime axis.
- Fixed #4502, wrong bounding box detection of rotated labels caused overlapping text in old IE.
- Fixed #4504, bars were misplaced when using reversed yAxis.
- Fixed #4510, point search along X axis failed in boost module.
- Fixed #4511, tooltip was not displayed, when yAxis.max cut off top part of the column.
- Fixed #4519, updatating pie data immediately failed with Standalone Framework.
- Fixed #4525, errors in exported SVG when allowHTML was true.
- Fixed #4526, series used the same clip-paths, which caused wrong clipping when using different axes.
- Fixed #4529, boost module produced error with pie charts.
- Fixed #4530, heatmap with single point and large colsize caused the point not to display.
- Fixed #4532, stack ID's as strings caused JS error in Highcharts 3D.
- Fixed #4536, unable to zoom in closely on first category when minRange was less than closest point range.
- Fixed #4543, null value bubbles should not be drawn.
- Fixed #4546, pie and flag series not showing tooltip correctly when displayed in a chart with shared tooltip.
- Fixed #4558, when resizing chart during addPoint animation cause error in stacking.
- Fixed #4562, logarithmic zAxis for 3D scatter did not render properly points.
- Fixed #4586, some markers moved by 1px after hovering.
- Fixed #4594, errors when stacking two series with different data lengths on a log axis.
- Fixed #4599, cropThreshold should be ignored when getExtremesFromAll is enabled.
- Fixed #4615, labels on color axis were wrongly positioned when useHTML.
- Fixed #4627, data labels exported twice in IE and Edge. Text shadows not rendered in Edge.
- Fixed issue with duplicated pane backgrounds after the #3176 fix.
- Fixed issue with offline export in Firefox. Closes #4550.
- Fixed regression with global animation and timing of calls.
- Fixed #2801, whiskerLength for boxplot can be set in pixels.
- Fixed #3323, 3d pie parts have better zIndexes, out part of slice crossing sides created, normalization of alpha and beta to (-360, 360) range.
- Partly fixed #1686, tooltip not hiding when mouse enters over it then out from series.
- Refactored columns. Separated the crisping logic from the rest of the translation logic. Related to #4179.