# Changelog for Highcharts v4.2.4 (2016-04-14)
        
- Added support for polar columnrange series.
- Added `e.originalEvent` to drilldown event in order to catch modifier keys and other properties. Closes #5113.
- Added new drilldown event, [chart.events.drillupall](https://api.highcharts.com/highcharts#chart.events.drillupall), that is triggered after multiple single drillup events. Closes #5158. Closes #5159.
- Added new option, [chart.options3d.fitToPlot](https://api.highcharts.com/highcharts#chart.options3d.fitToPlot) to fit 3D charts into the available plotting area. This may affect the layout of existing 3D charts if the layout was adjusted by ``chart.margin``. The ``chart.margin`` setting can now normally be removed. Closes #4933.
- Added new option, [lang.shortWeekdays](https://api.highcharts.com/highcharts#lang.shortWeekdays), to specify short weekdays other than the first three letters of the weekday.
- Added new value, `day`, for [pointIntervalUnit](https://api.highcharts.com/highcharts#plotOptions.series.pointIntervalUnit).
- Added option, [legend.navigation.enabled](https://api.highcharts.com/highcharts#legend.navigation.enabled), to allow disabling legend scroll.

## Bug fixes
- Fixed #3450, tooltip did not display after zooming on Android.
- Fixed #3916, halo and tooltip visible for points outside the plot area.
- Fixed #4552, mouse interaction and tooltip positions didn't match on 3D scatter chart.
- Fixed #4631, treemap series displayed no data even when data existed.
- Fixed #4679, when series are overlapping, the tooltip should show the topmost point.
- Fixed #4700, users can set and modify opacity on parent nodes in treemap.
- Fixed #474, vertical label alignment on top axis was off when labels were on multiple lines.
- Fixed #4751, inconsistent data label behaviour after redraw.
- Fixed #4784, setting allAreas to false does not center map.
- Fixed #4812, dataLabels which was supposed to be hidden were still visible.
- Fixed #4856, zooming did not work in Treemap.
- Fixed #4866, space was not reserved for tick marks, allowing ticks to overflow the chart when axis labels were not present.
- Fixed #4868, axis breaks were not applied for a range series.
- Fixed #4891, pie slice's graphics were not fully hidden, when slice was hidden.
- Fixed #4954, corrected floating values with isSum and isIntermediateSum in Waterfall series.
- Fixed #4961, placement of tooltip on flags for inverted charts.
- Fixed #4984, tooltip jiggling on arearange even when followPointer was true.
- Fixed #5007, JS error from tooltip when running in strict mode.
- Fixed #5010, stacked areas didn't work with Date objects as X values.
- Fixed #5029, runtime error on empty data set.
- Fixed #5030, bars were shaking on initial animation.
- Fixed #5034, a regression causing axis labels on vertical axis not to wrap.
- Fixed #5053, regressions related to chart callbacks firing async.
- Fixed #5060, date format for %e was not consistent with docs.
- Fixed #5063, solid gauge tooltip showed wrong series the first time.
- Fixed #5066, crosshair with snap: false only appeared when hovering a point.
- Fixed #5075, display was not deferred on data labels with useHTML.
- Fixed #5079, a regression causing vertical axis title to disappear in IE8.
- Fixed #5084, wrong Heatmap Intro was set in parts.js, which made the Download Builder fail.
- Fixed #5085, tooltip showed for points immediately outside the plot area on the X axis.
- Fixed #5086, X axis labels overlapped when added via Chart.addSeries.
- Fixed #5087, container with padding caused error with printing in IE8.
- Fixed #5099, single point marker was not displaying when surrounded by null points.
- Fixed #5101, click events did not fire on pie slices after Point.update.
- Fixed #5112, returning false from event handlers didn't cancel default function.
- Fixed #5133, data labels disappeared on chart redraw when defer was explicitly set to true.
- Fixed #5134, a regression causing wrong aniation on pie labels when moving from one side to the other.
- Fixed #5137, boost module threw JS error when doing mouse interaction after removing series.
- Fixed #5144, problem with percentage stack with null points.
- Fixed #5146, columns with zero value and no border on negative chart were visible even though they shouldn't.
- Fixed #5156, funnel did not respect the color set for selected state.
- Fixed #5160, data grouping and boost module did not play well together.
- Fixed #5167, wrong padding in bubble charts made point disappear after setting axis extremes.
- Fixed #5171, log scale transformation functions were not accessible from the outside.
- Fixed #5174, invalid CSS because of division by zero.