# Changelog for Highcharts v4.2.6 (2016-08-02)
        
- Added crisp correction for crisper treemap points.
- Added support for animating graphs to the right when updating data or setting axis extremes. Related to #5294.
- Refactored sideways animation logic for graphs to better reflect shifting data. Closed #5294.

## Bug fixes
- Fixed tick animation when `showFirstLabel` or `showLastLabel` were set to false.
- Fixed #2522, point names should fill up categories when X is not set.
- Fixed #2597, data labels remained visible even though container was hidden.
- Fixed #3571, treat NaN in data as null.
- Fixed #4204, `hover.brightness` wasn't used for positive bars in waterfall.
- Fixed #4216, `connectEnds` with `null` as first point failed.
- Fixed #5052, wrong placement of ticks on opposite axis on 3D charts.
- Fixed #5197, JS error on hovering chart after `setData` before `redraw`.
- Fixed #5215, JS error when legend configuration object was set to false.
- Fixed #5280, stacked area was wrong with non-zero Y axis threshold and data points at 0.
- Fixed #5287, unsnapped crossshair was hidden after adding points.
- Fixed #5298, empty cells in Google Spreadsheet made the graph disappear.
- Fixed #5302, `dateFormat` didn't handle Date objects like before.
- Fixed #5310, global stacking affected polygon series.
- Fixed #5311, JS error when setting an event config to null.
- Fixed #5322, negative values in pie series was rendered incorrectly.
- Fixed #5324, calling `Renderer.label` with a shape of `rect` failed.
- Fixed #5332, last axis label was stuck when doing repetetive redraws.
- Fixed #5337, tooltip for polygon should not behave like scatter points.
- Fixed #5339, plot area disappeared when categories were too long.
- Fixed #5348, error in arearange series when `trackByArea` was false.
- Fixed #5350, 3D pies failed redraw when animation was off.
- Fixed #5352, treemap tooltip did not format point value.
- Fixed #5354, `noSharedTooltip` was undefined for gauge and solid gauge, which caused errors when shared tooltip was enabled.
- Fixed #5376, axis title position was wrong with font-size text values.
- Fixed #5396, drilldown `activeDataLabelStyle` color contrast did not work.
- Fixed #5417, regression causing HTML axis labels to misbehave with useHTML and rotation.
- Fixed #5442, incorrect clipRect counter causing points to disappear on series update.
- Fixed #5480, axis showed 0k or 0M. Suffix not needed for zero.
- Fixed #5486, threshold `null` caused wrong fill on all-negative axis.
- Fixed #5495, shared tooltips not always working because of rounding error.
- Fixed #5500, pyramid height caused wrong position.
- Fixed #5504, exporting module default settings was not compatible with https.
- Fixed #5513, `Chart.setSize` required both width and height to be set.
- Fixed #5519, issues with setting null colors in drilldown.
- Fixed #5522, 3D charts scale differently first time versus subsequent redraws.
- Fixed #5523, marker radius was incorrect when values were of type string.
- Fixed issues with PNG/JEPG in IE and Edge in offline exporting, ref #5410.
- Fixed issue #5410, offline exporting in IE/Edge failed with embedded images for PNG/JPEG.