# Changelog for Highcharts v5.0.11 (2017-05-04)
        
- Added [export-data](https://github.com/highcharts/export-csv/) as an experimental module in the main repo.

## Bug fixes
- Fixed #1174, added dataLabels distance option for single pie point.
- Fixed #4743, updating 3D columns with z stacking failed.
- Fixed #5045, line series should be broken on axis breaks. Moved `gapSize` logic to the broken-axis module.
- Fixed #5297, 3D columns were overlapping.
- Fixed #5424, crosshairs overlapping when there is multiple axis with equal positions.
- Fixed #5863, panning didn't allow panning back to the extreme data values.
- Fixed #5911, inverted waterfall was rendered incorrectly.
- Fixed #6046, copy classes by reference in stead of a hard copy in merge.
- Fixed #6218, some tooltip options were not updated through chart.update().
- Fixed #6296, regression causing bubbles not to be clipped.
- Fixed #6350, solid gauge series did not have CSS point class.
- Fixed #6420, when multiple axes, show only one snapping crosshair at the same time.
- Fixed #6440, callout anchor was mispositioned in an inverted chart.
- Fixed #6441, callout animated to wrong position on point update.
- Fixed #6488, destroying colorAxis caused error and left legend.
- Fixed #6527, `point.color` of negative column was less important than `series.negativeColor`.
- Fixed #6549, Y-values of 0 caused the point to be skipped in boost mode.
- Fixed #6550, a regression causing sprites in meteogram sample not being clipped after animation, resulting in weather symbols all over.
- Fixed #6563, a regression causing flat integer data to draw on the X axis when `allowDecimals` was false.
- Fixed #6566, zAxis wasn't updated through chart.update().
- Fixed #6569, `chart.exportChart()` left undefined item in the `Highcharts.charts` array.
- Fixed #6574, subtitle was rendered outside the chart when setting `subtitle.verticalAlign` to `'bottom'`.
- Fixed #6580, blending in boost caused barely visible markers in scatter charts.
- Fixed #6585, zero-value column's dataLabel was misplaced when using logarithmic yAxis.
- Fixed #6586, directTouch did not work with shared tooltip.
- Fixed #6589, pie chart didn't accept undefined values.
- Fixed #6597, PointerEvent was used unnecessarily, causing bad behaviour on Android.
- Fixed #6606, no legend keyboard navigation when heatmap module loaded.
- Fixed #6608, small maxHeight didn't hide all legend items.
- Fixed #6609, entities in the legend title were not translated.
- Fixed #6617, rendering a chart in a hidden container with box-sizing. Rewrote the functionality to avoid rendering in a hidden div, so that instead of cloning the div we make the current div temporary visible.
- Fixed #6627, marker symbol wasn't checked properly.
- Fixed #6636, a regression causing missing ticks with negative timezone offset.
- Fixed #6637, null point broke chart.
- Fixed #6639, accessibility issues with new export-csv versions.
- Fixed #6641, pane axis caused the error in defualt charts.
- Fixed #6646, item title was not wrapped in styled item.
- Fixed #6650, boost module failed with styled mode and heatmap.
- Fixed #6653, exporting error with IE8.
- Fixed #6660, changing colorIndex did not update all series styles.
- Fixed issue in tooltip-outside-box study with narrow windows. Touch #6658.
- Fixed merge problems with #6576.