# Changelog for Highcharts v5.0.13 (2017-07-27)
        
- Added `pos`, axis `pos`ition, to axis label formats. Closes #6859.
- Added `accessibility.keyboardNavigation.tabThroughPoints` option, ref #6886.
- Added `legend.keyboardNavigation.enabled` option, ref #6838.
- Added color animation on state change for non-marker based series like columns and tree maps.
- Added feature to line-wrap long axis titles by default. Fixed #6893, causing multiline axis titles to overlap axis labels.
- Added new option, `exporting.menuItemDefinitions`, and allow string keys to be used in the `menuItems` instead of redefining full objects.
- Added new option, `yAxis.stackLabels.allowOverlap`, to prevent stack labels from overlapping. Closes #6876.
- Added new parameter `oneToOne` to the `chart.update` function. This allows for easier integration of Highcharts into dashboard solutions and wrapper APIs.
- Added markers to arearange and areapsplinerange series. Closed #6736.
- Removed error message 27 because of conflict when using highcharts-more with maps module. See #6686.

## Bug fixes
- Fixes #6981, wrong layout on inverted heatmaps.
- Fixed #3946, stackLabels were not working in 3D column chart.
- Fixed #4853, legend's border wasn't respecting checkboxes.
- Fixed #5783, the chart width and text bounding boxes were not picked up when the chart was rendered to an element that was detached from the DOM.
- Fixed #6115, returning an array from tooltip formatter with false value didn't hide split tooltip item.
- Fixed #6342, class names were not updated on HTML elements.
- Fixed #6418, HTML data labels and refreshing and deleting caused JavaScript exceptions.
- Fixed #6616, the border was drawn in a full circle pie slice.
- Fixed #6695, cursor pointer was missing on drilldown line charts.
- Fixed #6708, 0 value bars were incorrectly drawn in 3D chart.
- Fixed #6740, tooltip not hidden when tabbing out of chart.
- Fixed #6746, events for legacy IE (6-8) didn't have unique keys.
- Fixed #6747, crosshairs in column charts caused flickering on mouse move in IE and Edge.
- Fixed #6752, `activeDataLabelStyle` used to override dataLabel's styles set on a point.
- Fixed #6760, `tooltip.enabled: false` did not respond to responsive configuration.
- Fixed #6761, scatter series data was not correctly exported in the export-data module.
- Fixed #6763, treemap was missing directTouch property, causing color axis marker to disappear.
- Fixed #6764, fixed #6791, fixed #6808, addition #6687. Series with noSharedTooltip was unaccessible when tooltip was shared.
- Fixed #6769, hidden series legend had invalid stroke-width attribute.
- Fixed #6773, updating `xAxis.range` didn't change extremes.
- Fixed #6774, exponential numbers were not correctly handled by number formatter.
- Fixed #6776, color animation was not working correctly for flags and 3D columns.
- Fixed #6778, new ellipsis functionality did not account for rotation.
- Fixed #6781, dataLabels were misaligned on inverted chart when configured xAxis.height.
- Fixed #6784, 3D draggable scatter demo didn't work on touch devices.
- Fixed #6792, updating `point.marker.symbol` to null didn't restore default point's marker.
- Fixed #6803, charts inside `display:none` divs became visible in Edge and IE.
- Fixed #6804, not able to touch-scroll the page on chart with zoom.
- Fixed #6831, tooltip border color was ignored by split option.
- Fixed #6835, columnrange disappeared when zooming too far in.
- Fixed #6838, consider hidden series in keyboard navigation.
- Fixed #6841, the `dataLabels.crop` option had no effect on pie charts.
- Fixed #6860, crosshairs on multiple axis was drawn on wrong position.
- Fixed #6879, shadow was not applied for split toolip.
- Fixed #6888, `legend.update` caused color axis to disappear in heat maps.
- Fixed #6897, prevented axis extremes change in case of a single point if multiple ticks are set.
- Fixed #6898, 3d pie chart had wrong color for sides in styled mode.
- Fixed #6900, column border radius was not respected in styled mode.
- Fixed #6912, responsive rules affecting series killed animation and data labels.
- Fixed #6956, improved colors and treemap for IE8.
- Fixed #6968, chart height didn't reflow when `chart.width` was set.
- Fixed #6970, flags were not filled in styled mode.
- Fixed #6971, rounding errors caused flickering of solid gauge backgrounds in semi circles.
- Fixed #6988, `dataClass.color` should be ignored in styled mode.