# Changelog for Highcharts v5.0.3 (2016-11-18)
        
- Added new option, [lang.numericSymbolMagnitude](https://api.highcharts.com/highcharts/lang.numericSymbolMagnitude), to support numeric symbol shortening in Japanese, Korean and certain Chinese locales.
- Added new option, [threshold](https://api.highcharts.com/highcharts/plotOptions.solidgauge.threshold), for solid gauge series.
- Added new CSS custom property, `textOutline`, and at the same time removed the `textShadow` shim. Closes #5849.
- Better implementation of the [chart.pinchType](https://api.highcharts.com/highcharts/chart.pinchType) option. Allow `pinchType` and `zoomType` to be set independently. When `tooltip.followTouchMove` is true, `pinchType` only applies to two-finger touches. Closes #5840.
- Changed the `Highcharts.addEvent` function to return a callback to be used to remove the same event.
- Implemented bubbles in the Boost module.
- Improved alignment of ticks on multiple axes by allowing ticks to be placed at less strict intervals.
- Refactored split tooltip connectors to use common callback shape instead.

## Bug fixes
- Fixed #3802, `yAxis.opposite` ignored when `setOptions` was used.
- Fixed #3949, added zIndex calculation for scatter in 3D chart.
- Fixed #5838, split tooltip ignored style options.
- Fixed #5859, tooltip display problems in styled mode.
- Fixed #5868, dataLabels.softConnector was always set to true.
- Fixed #5873, bubbles hidden in small charts when maxSize is percentage.
- Fixed #5873, bubbles hidden in small charts when maxSize is percentage.
- Fixed #5889, `pointPlacement` did not respect individual series `pointRange`.
- Fixed #5895, Axis.update failed with solid gauge Y axis.
- Fixed #5897, Series.pointAttribs ignored some lineWidth options.
- Fixed #5899, HTML label bounding box was cached when a width was set in inner HTML.
- Fixed #5903, a regression causing the halo to cover bubbles so the bubbles weren't clickable.
- Fixed #5909, `plotBand` border was only drawn on three out of four sides of the rectangle.
- Fixed #5912, legend clipping was not removed after resizing to larger size.
- Fixed #5915, returning false from tooltip formatter only hid the tooltip when it was present from before.
- Fixed #5919, default `exporting.libURL` used insecure HTTP.
- Fixed #5921, horizontal legend has height limit even when floating.
- Fixed #5922, Tooltip.refresh crashed when formatter returned undefined.
- Fixed #5926, more unique id's for clipping and other internal `defs`. Prevents conflicts when SVGs from different sources are pasted in the same page.
- Fixed #5928, first tick disappeared when redrawing chart with type category and `uniqueNames = false`.
- Fixed #5931 and #5957, refactured updateButtonStates to fix issues with states of Rangeselector buttons.
- Fixed #5932, line height was wrong in tooltip with nested em units.
- Fixed #5934, series.className was missing a trailing space in the legend item.
- Fixed #5935, a regression when axis was crossing DST in a timezone west of UTC.
- Fixed #5938, dynamic inversion didn't work without setting certain other properties at the same time.
- Fixed #5940, disabling the legend via `Legend.update` did not reclaim legend space.
- Fixed #5944, offline exporting and styled mode resulted in unstyled, black chart.
- Fixed #5951, `responsive.rules.condition.callback` did not work according to documentation.
- Fixed #5959, hidden series affecting axis closest point calculation.
- Fixed #5960, incorrect series order after removing and adding series.
- Fixed #5968, xAxis labels did not have ellipsis when rotation was set to 0, in Firefox and Edge.
- Partially fixed #5047. Workaround with was given static width and height.