# Changelog for Highcharts v5.0.7 (2017-01-17)
        
- Added Legend keyboard navigation to accessibility module.
- Added chart render and predraw events needed by the new Boost module.
- Added new option, [global.timezone](https://api.highcharts.com/highcharts/global.timezone), as a convenient shortcut to timezones defined with moment.js.
- Added optional redraw to `drillToNode`, related to #6180.
- Added support for [marker.symbol](https://api.highcharts.com/highcharts/plotOptions.bubble.marker.symbol) setting on bubble charts.
- Changed the `Highcharts.addEvent` function to return a callback to be used to remove the same event.
- Changed the [Highcharts.error](https://api.highcharts.com/highcharts/Highcharts.error) function to handle strings.

## Bug fixes
- Fixed compliance with Checkmarx security checker.
- Fixed #6108, issue with big data in offline exporting.
- Fixed #5672, X values in tooltip in Boost module was wrong.
- Fixed #5553, disabled `trackByArea` did not hide tooltip, when moving mouse out of the area shape.
- Fixed #5757, empty chart throws error with accessibility module.
- Fixed #5766, halo was not rendered for shared tooltip when density of points was high.
- Fixed #5818, render halo in a series group, not under all of the groups.
- Fixed #5819, crosshair width can now be set on category axes also.
- Fixed #5833, split tooltip tried to remove series tooltip again after destruction.
- Fixed #5835, exported SVG didn't validate, width and height attributes were set on group elements.
- Fixed #5837, could not style null points with CSS.
- Fixed #5855, split tooltip was not destroyed properly.
- Fixed #5862, wrong hover point, when tooltip was shared.
- Fixed #5866, treemap `point.isNull` was always true.
- Fixed #5868, `dataLabels.softConnector` was always set to true.
- Fixed #5873, bubbles were hidden in small charts when `maxSize` was percentage.
- Fixed #5884, optimizing addSeries.
- Fixed #6085, floating point errors on Y axis labels.
- Fixed #6088, rounding issue in tooltips.
- Fixed #6107, error with negative width in xrange study.
- Fixed #6112, issue and regression with swapping series indexes.
- Fixed #6113, long legend items were unresponsive due to heavy HTML parsing in SVG. Implemented caching.
- Fixed #6127, pie chart data label overlapped after drill up.
- Fixed #6128, tooltip caret was not drawn after updating from shared to non-shared.
- Fixed #6130, `Chart.update` didn't trigger responsive rules to be re-evaluated.
- Fixed #6138, reset colorCounter and symbolCounter when all series are removed.
- Fixed #6147, error in Chart.get when called between redraws.
- Fixed #6157, offline exporting was not working for Edge.
- Fixed #6158, duplicate ID of navigator series.
- Fixed #6171, drawDataLabels did not use updated options when data label already existed.
- Fixed #6173, no inline CSS should be allowed in styled mode.
- Fixed #6180, treemap crashed when the root node did not exist.
- Fixed #6184, polar arearange was misshaped when `connectEnds` was not set.
- Fixed #6196, dead clip path references.
- Fixed #6200, modified treemap `setPointValues` to only add crisping correction when needed.
- Fixed #6202, legend icons overflowed legend with large radius.
- Fixed #6207, when point X was given, point names did not show on category axis after hiding and showing series.
- Fixed #6208, error on responsive rules for `plotOptions.series` and `series.xAxis`.
- Fixed #6213, wrong text bounding box reported in Chrome for Windows, resulting in asymmetric label padding.
- Fixed #6217, container sizes below 20px height needed explicit chart height to be set.
- Fixed issue in offline exporting where libURL option was not picked up.
- Fixed issue with duplicate `highcharts-negative` class. Ref #6114.