# Changelog for Highcharts v5.0.8 (2017-03-08)
        
- Added a refactored Boost module based on WebGL. Details and API to be announced.
- Added [animation](https://api.highcharts.com/highcharts/plotOptions.series.states.hover.animation) on graph mouse over and mouse out.
- Added hooks so that users can define their own log axis conversion functions, and can advertise that the log axis should allow [negative values](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/samples/highcharts/yaxis/type-log-negative/).
- Added new option, [solidgauge.rounded](https://api.highcharts.com/highcharts/plotOptions.solidgauge.rounded).
- Added support for relative [chart.height](https://api.highcharts.com/highcharts/chart.height) as a percentage of the width. This allows for fixed aspect ratio.

## Bug fixes
- Fixed #223, pie chart data labels overflowed after pie reached minimum size.
- Fixed #2322, updating series type caused remnants of the original series type after multiple updates.
- Fixed #4916, data values were lost in export after updating a point from a numeric or array configuration to an object configuration.
- Fixed #5915, returning false from tooltip formatter only hid the tooltip when it was present from before.
- Fixed #6087, `minPointLength` shifted next points rendering.
- Fixed #6173, another case of unwanted inline CSS in style mode.
- Fixed #6187, navigator jumped back after dragging on touch devices.
- Fixed #6254, `Point.update` did not apply new class names.
- Fixed #6264, enabling individual bubble markers did not work.
- Fixed #6272, inverted stack area chart was badly drawn when containing nulls.
- Fixed #6274, `allowDecimals: false` was ignored with flat data.
- Fixed #6278, missing ticks before DST crossover in some cases.
- Fixed #6282, text-align did not take effect on data labels with useHTML.
- Fixed #6291, multiple responsive rules were applied an unapplied in wrong order when resizing.
- Fixed #6301, legend width option caused wrong alignment when aligned right.
- Fixed #6305, accessible keyboard navigation in polar charts not working correctly.
- Fixed #6314, treemap series failed with error in styled mode.
- Fixed #6321, bubbles were hidden when close and marker.enabled set to null.
- Fixed #6322, legend navigation arrows did not update correctly on responsiveness.
- Fixed #6328, issue with disabled tooltip in accessibility module.
- Fixed #6330, minor ticks affecting the computed extremes of Y axes in some cases.
- Fixed #6330, minor ticks were not applied outside major ticks on a logarithmic axis.
- Fixed #6347, error on applying responsive rules where series or axis length was greater than the existing chart.
- Fixed #6356, `legend.maxHeight` not respected after chart update.
- Fixed #6361, accessibility failing for IE8 and older.
- Fixed #6370, category axis with breaks was rendered incorrectly.
- Fixed #6384, `Point.update` didn't work with slice: false.
- Fixed #6387, graph and area rendered differently on area splines next to null points.
- Fixed #6399, treemap legend item had incorrect color after point was hidden.
- Fixed #6401, `point.states` didn't work for maps.
- Fixed #6402, treemap `ignoreHiddenPoint` is now true by default.