# Changelog for Highcharts v6.0.0 (2017-10-04)
        
- Added [Annotations module](https://www.highcharts.com/docs/advanced-chart-features/annotations-module) for annotating a chart with labels or shapes.
- Added the Boost module for WebGL rendering of millions of points.
- Added the [Series labels](https://api.highcharts.com/highcharts/plotOptions.line.label) module for organic positioning of labels next to the data.
- Decoupled old IE code into a separate module.
- Added new series type, [bell curve](https://www.highcharts.com/docs/chart-and-series-types/bell-curve-series).
- Added new series type, [bullet chart](https://www.highcharts.com/docs/chart-and-series-types/bullet-chart).
- Added new series type, histogram.
- Added new chart layout, [parallel coordinates](https://www.highcharts.com/docs/chart-and-series-types/parallel-coordinates-chart) chart.
- Added new series type, [pareto chart](https://www.highcharts.com/docs/chart-and-series-types/pareto-chart).
- Added new series type, [sankey chart](https://www.highcharts.com/docs/chart-and-series-types/sankey-diagram).
- Added new series type, 3D scatter chart.
- Added new series type, [stream graph](https://www.highcharts.com/docs/chart-and-series-types/stream-graph).
- Added new series type, [sunburst](https://www.highcharts.com/docs/chart-and-series-types/sunburst-series).
- Added new series type, [variable pie](https://www.highcharts.com/docs/chart-and-series-types/variable-radius-pie-chart).
- Added new series type, [variwide](https://www.highcharts.com/docs/chart-and-series-types/variwide-chart).
- Added new series type, [vector plot](https://www.highcharts.com/docs/chart-and-series-types/vector-plot).
- Added new series type, [wind barbs](https://www.highcharts.com/docs/chart-and-series-types/wind-barbs-series).
- Added new series type, [word cloud](https://www.highcharts.com/docs/chart-and-series-types/word-cloud-series).
- Added new series type, [X range](https://www.highcharts.com/docs/chart-and-series-types/x-range-series).
- Improved CSV parser of the data module.

## Bug fixes
- Fixed #5909, plotband border on top was missing.
- Fixed #6005, selected pie slice had wrong color in styled mode.
- Fixed #6261, a regression causing charts to draw at small heights if container size was small.
- Fixed #6268, `Chart.update()` did not update parameters of the data module.
- Fixed #6302, chart was not rendered when `xAxis.max` and `rangeselector.selected` were defined.
- Fixed #6648, the `redraw` parameter in `Series.setVisible` was not respected when Boost module was loaded.
- Fixed #6679, a regression causing drilldown not to fire the second time in certain cases.
- Fixed #6957, when `tooltip.useHTML` was true on a map and other series types, the shape would flicker and tooltip hide in IE and Edge.
- Fixed #6992, error in data label positioning with really small pies.
- Fixed #7012, series group was wrongly translated when 3d columns were added to graph.
- Fixed #7021, cleared duplicated marker reference.
- Fixed #7024, regression causing charts not to show when preliminary rendering within a child of a detached node.
- Fixed #7025, treemap with color axis didn't work in styled mode.
- Fixed #7030, added `highcharts.scss` to distribution.
- Fixed #7031, could not set up Highcharts with a custom window object.
- Fixed #7034, color tweening from a named (unrecognized) color to a hex color failed.
- Fixed #7046, a zero value point using `minPointLength` was always shown as a positive value point.
- Fixed #7061, line was missing after zooming between points.
- Fixed #7080, JS error on adding rotated data labels with shadow applied.
- Fixed #7084, high or non-ASCII characters in CSV file were not exported correctly in IE.
- Fixed #7088, series didn't hide dynamically in Boost mode.
- Fixed #7090, offline generated PDF showed hidden series.
- Fixed #7112, pie chart data labels were visible for negative values.
- Fixed #7113, updating a pie chart to all negative values didn't clear the slices.
- Fixed #7115, version format not validated by yarn.
- Fixed #7117, plot line label had wrong position in polar charts with circular grid lines.
- Fixed #7126, less than sign followed by a space was interpreted as markup.
- Fixed #7127, exception in Pointer when updating a series from its own mouseOver event handler.
- Fixed #7128, data export with combined scatter and column series inserted too many rows.
- Fixed #7160, treemap should not display halo on hover.
- Fixed #7175, NaN in text position of plot band label after toggling series visibility.
- Fixed #7180, disabling tooltip caused event flooding.
- Fixed #7188, null points creates issues for shared tooltip, when there is more than one point with same x value.
- Fixed #7193, fixed #7159, hoverPoints in boost mode was not usable for Tooltip.
- Fixed #7028, axis label width style wasn't respected if there was enough space to render wider labels.