# Changelog for Highcharts v6.0.4 (2017-12-15)
        
- Added feature, [xAxis.labels.reserveSpace](https://api.highcharts.com/highcharts/xAxis.labels.reserveSpace) option only worked when setting it to false, could not be set to true to force reserved space. See #5286.
- Added new option on flag series, `allowOverlapX`, to be able to toggle the new feature of overlap avoidance. See #4674.
- Made keyboard navigation for points work more intuitively, highlights last/first point depending on direction, and wraps around at end.
- Added option `data.sliced` and `slicedOffset` in Sunburst.

## Upgrade notes
- Highcharts now makes room for the legend in the layout if it has `verticalAlign: 'top'` with a horizontal legend. In existing charts using this layout, the layout of the legend and the plot area may be affected.
- Fixed #1019, right mouse button dragging should not #1344 trigger zoom**.

## Bug fixes
- Moved accessibility of tables to export-data module. Fixes #7400 and #7486.
- Fixed #1019, right mouse button dragging should not trigger zoom.
- Fixed #3965, tickAmount was adding ticks only with bigger value than max for single value axis.
- Fixed #4939, null points in box plot caused the Y axis extremes to fail and all valid points were lost.
- Fixed #4958, the `pointIntervalUnit` option didn't handle the DST crossover correctly when set to 'days'.
- Fixed #6096, reset zoom button covered the tooltip.
- Fixed #7042, very small values were not respecting the decimals setting in numberFormat function.
- Fixed #7226, zooming was not possible when `softMin` and `softMax` were set.
- Fixed #7248, labels in polar charts were clipped when overflowing the chart edges.
- Fixed #7287, some nested HTML elements in SVG were updating wrong groups.
- Fixed #7314, Updated wordcloud to use font family sans-serif by default.
- Fixed #7363, a regression in animation logic causing sunburst data labels not to show after drilling.
- Fixed #7381, vector series points were visible outside current plot area.
- Fixed #7384, data label was not visible after drilling up in pie and column charts in Chrome.
- Fixed #7394, Infinity value broke heatmaps and potentially other charts. See also #3571.
- Fixed #7397, updating chart type changed rendered series Z index.
- Fixed #7404, data export from pie chart failed if the point name was an empty string.
- Fixed #7405, small numbers in exponential notation were wrongly interpreting decimals.
- Fixed #7406, heatmap was faded when hovering legend in styled mode.
- Fixed #7411, chart axis disappeared with hidden series in navigator.
- Fixed #7413, setting [drilldown.animation.duration](https://api.highcharts.com/highcharts/drilldown.animation.duration) to 0 caused orphaned column shapes after drilling up.
- Fixed #7414, data label text color was wrong with rotated labels in styled mode.
- Fixed #7415, keyboard navigation not working with legend paging.
- Fixed #7418, event handling in iOS led to all series being faded out in styled mode after tapping close to legend items.
- Fixed #7420, a regression causing stacked column graphs to fail when `threshold` was `null`.
- Fixed #7421, added [keyboardNavigation.mode](https://api.highcharts.com/highcharts/keyboardNavigation.mode) option with serializing functionality.
- Fixed #7423, bad default behavior for accessibility `skipNullPoints` and `pointDescriptionThreshold`.
- Fixed #7428, legend overlapped title and subtitle when vertically aligned to top.
- Fixed #7432, ticks not correctly placed on midnight in some cases when the first tick was close to DST crossover.
- Fixed #7437, a regression causing 3d pie slices not to move on second update using `Chart.setSize()`.
- Fixed #7439, errors on drilling down in styled mode treemap.
- Fixed #7448`,` CSV export problem with auto-detecting decimal points and item delimiters. Item delimiters now default to `;` if the detected browser locale has `,` for decimal points.
- Fixed #7451, a regression causing panning out of data bounds on category axes.
- Fixed #7457, function was not accepted as binsNumber for histogram series.
- Fixed #7463, extra tick was inserted on zoom when using the [xAxis.tickPositions](https://api.highcharts.com/highcharts/xAxis.tickPositions) option.
- Fixed #7475, a regression causing `xAxis.label.overflow: false` not to work.
- Fixed #7477, 3D line series moved as series visibility was toggled.
- Fixed #7478, plot border didn't redraw when animation was active.
- Fixed #7481, error in stacked chart with predefined axis bounds using boost.
- Fixed #7485, Mozilla Addons Linter found a bad word in the source code.
- Fixed #7489, sankey chart was not compatible with no-data module.
- Fixed #7493, stacked area chart didn't respect `connectNulls: false` after updating point to null.
- Fixed #7494, chart height increased on window resize in styled mode.
- Fixed #7495, small gaps were visible between the halo and the pie slices in pie charts due to SVG anti aliasing.
- Fixed #7507, visible and misplaced wind barbs when outside plot area.
- Fixed wrong context in animation complete callback when skipping animation due to equal attributes. See #7146.