# Changelog for Highcharts v6.0.5 (2018-01-31)
        
- Added `states.normal` to allow disabling animation after point or series hover.
- Added chart-level [time options](https://api.highcharts.com/highcharts/time).
- Added new sankey options, `node.column` and `node.offset`.
- Added option, `series.marker.enabledThreshold`, for setting the break point between enabling and disabling markers.
- Added support for `connectNulls` in the Boost module. See #7395 and #7631.

## Bug fixes
- Fixed #4647, custom buttons from exporting can be created without tooltip.
- Fixed #4699, lines pass through data points in inverted waterfall.
- Fixed #6712, [xAxis.scrollbar](https://api.highcharts.com/highcharts/xAxis.scrollbar) was not listed in the API docs.
- Fixed #6985, arearange didn't remove old markers on zoom.
- Fixed #7179, HTML entities were not escaped in title elements.
- Fixed #7273, disabled markers caused wrong offset on a point hover with image as symbol.
- Fixed #7281, streamgraph gave wrong Y axis extremes when [yAxis.reversedStacks](https://api.highcharts.com/highcharts/yAxis.reversedStacks) was false.
- Fixed #7388. added option `sunburst.levelSize` and `sunburst.levels.levelSize` to customize ring sizes.
- Fixed #7467, [rangeSelector.selected](https://api.highcharts.com/highcharts/rangeSelector.selected) didn't work on a year buttons with `offsetMin`.
- Fixed #7499, errors and bad redrawing on adding and removing series with Boost module.
- Fixed #7507, windbarbs immediately on the edge of a zoomed chart were mispositioned.
- Fixed #7515, null X values in all data points of one series caused all other series to hide.
- Fixed #7517, sunburst used wrong value to calculate size of root node.
- Fixed #7523, error on drilldown in styled mode.
- Fixed #7529, regression with label positioning and useHTML in Edge and IE.
- Fixed #7534, `point.isInside` was set to true in a cropped point - added extra check for a point's graphic prop.
- Fixed #7538, offline PDF export did not handle fonts with multiple charts.
- Fixed #7555, huge peak values caused smaller values not to render when zooming in on stacked area chart.
- Fixed #7557, arearange series in boost mode threw errors when zooming out from SVG mode.
- Fixed #7597, added property `outerArcLength` to sunburst as an alternative filter to `innerArcLength`.
- Fixed #7600, `Chart.update` with drilldown didn't work.
- Fixed #7602, error on calling `chart.drillUp` when chart was not drilled into.
- Fixed #7607, box plot whiskers and median appeared on hover if their width was set to 0.
- Fixed #7611, null pointer exception on destroying the chart from selection event.
- Fixed #7617, xrange series had mispositioned `partialFill` after zooming in.
- Fixed #7621, hourly datetime label was skipped instead of repeated when crossing DST change.
- Fixed #7633, style CSP error when using `legend.useHTML`.
- Fixed #7634, errors when using the Boost module in combination with non-boostable series types.
- Fixed #7646, tooltip didn't work on flags in boosted chart.
- Fixed #7656, major performance hits when using axis labels with `useHTML = true`.
- Fixed #7663, data labels in `variablePie` were wrongly positioned.
- Fixed #7667, waterfall caused errors when stacking null points.
- Fixed #7669, annotations not working in styled mode.
- Fixed #7677, after removing an annotation the chart threw errors.
- Fixed #7681, point halo stayed after pie resizing.
- Fixed #7696, improved documentation for `tooltip.split` and `tooltip.shared` options.
- Fixed #7709, a regression causing plot bands not to render if from or to was Infinity.
- Fixed #7725, slow performance when using [xAxis.uniqueNames](https://api.highcharts.com/highcharts/xAxis.uniqueNames) and lots of categories.
- Fixed #7726, synced charts failed with disabled `xAxis.crosshairs.snap`.