# Changelog for Highcharts v6.1.0 (2018-04-13)
        
- Added feature for loading data directly from a [CSV URL](https://api.highcharts.com/highcharts/data.csvURL) or JSON resource, and keeping it dynamically updated through the [data.enablePolling](https://api.highcharts.com/highcharts/data.enablePolling) option.
- Added examples of themes with styled mode: dark-unica, sand-signika, grid-light.
- Added feature to animate the series when updating data through `Series.setData`, `Series.update` or `Chart.update`. The new logic looks for matching X values and can be disabled through `setData's` `updatePoints` option.
- Added Open in Cloud functionality in the export-data module.
- Added pattern fill module.
- Added new feature, [chart.scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea), to provide smooth scrolling of data on small devices.
- Added `animation` parameter to `Chart.update`.
- Added default max-width for pie data labels to avoid long labels squeezing the pie itself.
- Added new option, [data.beforeParse](https://api.highcharts.com/highcharts/data.beforeParse), to allow modifying the CSV when using the `data.csvURL` option.
- Added new option, [legend.alignColumns](https://api.highcharts.com/highcharts/legend.alignColumns), providing better default layout for multiline horizontal legends.
- Added support for `Infinity` and -`Infinity` values for [plotOptions.area.threshold](https://api.highcharts.com/highcharts/plotOptions.area.threshold), to make the area extend towards either Y axis extreme. Closes #8139.
- Added support for nested [series.keys](https://api.highcharts.com/highcharts/series.keys).
- Added options `minFontSize` and `maxFontSize` to Wordcloud.

## Bug fixes
- Fixed #7792 #7791, inverted charts not clipping correctly in Boost.
- Added max distance to the label distribution function, so pie data labels and flags are not drawn too far away from the anchor point.
- Fixed #4881, data labels with `useHTML` caused recursion error in Firefox on Windows.
- Fixed #7026, export-data did not work when the boost module was active.
- Fixed #7103, dataLabels not cropped outside extremes.
- Fixed #7186, added new build script to dist task. Build and includes es-modules in distribution.
- Fixed #7362, dataLabels were overlapping when rotation was set.
- Fixed #7383, SVG title tag not configurable.
- Fixed #7491, missing words in Wordcloud because of too small playing field.
- Fixed #7604, axes ticks were wrongly aligned when startOnTick or endOnTick were set to alse.
- Fixed #7639, wrong extremes after repeated zoom in scatter charts.
- Fixed #7798, stack labels weren't correctly positioned with multiple yAxis.
- Fixed #7850, legacy IE wasn't getting classes of DOM elements correctly.
- Fixed #7857, panning was not working when xAxis was reversed.
- Fixed #7862, connector lines were not visible in waterfall series when negativeColor was used.
- Fixed #7874, wrong legend item positions when using HTML after setting chart size.
- Fixed #7894, [legend.verticalAlign](https://api.highcharts.com/highcharts/legend.verticalAlign) `top` failed with no chart title.
- Fixed #7896, streamgraph rendering and tooltip issues with single series.
- Fixed #7898, drillup button with long text was not correctly aligned after multi-level drilldown.
- Fixed #7906, error in gauge chart if no [yAxis.labels](https://api.highcharts.com/highcharts/yAxis.labels) config was provided in styled mode.
- Fixed #7931, error in series-label module when animating while chart was destroyed.
- Fixed #7933, setting `startPoint` dynamically failed when data set was empty initially.
- Fixed #7942, yAxis ticks and title had wrong positions after toggling series visibility.
- Fixed #7957, custom buttons in exporting didn't rescale image symbols.
- Fixed #7965, could not toggle the [chart.reflow](https://api.highcharts.com/highcharts/chart.reflow) option dynamically with `chart.update()`.
- Fixed #7968, a regression causing ellipsis setting [xAxis.labels.style](https://api.highcharts.com/highcharts/xAxis.labels.style) not to work.
- Fixed #7975, long pie chart data labels were not correctly truncated, and could not be disabled.
- Fixed #7986, invalid exported CSS when using comma item delimiter and best-guess decimal point in European locales.
- Fixed #7991, treemap had wrong root on export.
- Fixed #7996, polar chart with particular values was rendered wrong.
- Fixed #8008, drilldown data points set as arrays with keys failed.
- Fixed #8014, `Chart.setTitle` didn't result in legend position updating.
- Fixed #8060, markers flickering after `setData()` when redraw was deferred.
- Fixed #8073, animation of graph with center step was distorted.
- Fixed #8075, adding and removing axes dynamically caused redraw error.
- Fixed #8083, wrong crosshair width and position for variwide chart.
- Fixed #8092, [plotOptions.bubble.sizeByAbsoluteValue](https://api.highcharts.com/highcharts/plotOptions.bubble.sizeByAbsoluteValue) did not render bubbles when z-values were very close.
- Fixed #8100, arearange markers did not correctly support negativeColor and zones.
- Fixed #8101, wrong decimal separator in tooltip with multiple values.
- Fixed #8104, selected state attributes for a point were not applied in xrange series.
- Fixed #8106, context was not preserved inside lin2log and log2lin axis functions.
- Fixed #8119, point class name was not applied to the halo and connector.
- Fixed #8129, yAxis with `tickPixelInterval=1` rendered tick close to zero instead of zero.
- Fixed Series.update to support soft series name without recreating series.
- Fixed data module failing to initialize chart when the data config was empty.
- Fixed errors in plugins when destroying a chart from its own callback.
- Fixed issue with legend navigation sometimes not focusing for single legend item charts.
- Fixed issues with resizing points with autocalculated pattern dimensions.