# Changelog for Highcharts v6.1.1 (2018-06-27)
        
- Added new feature, [proximate legend layout](https://api.highcharts.com/highcharts/legend.layout), to allow placing legend items close to the data series.
- Added new option, [tooltip.outside](https://api.highcharts.com/highcharts/tooltip.outside), to allow the tooltip to render outside the confinement of the chart area. Closes #5784.
- Added clearer error reporting to offline exporting. Closes #8226.
- Added default for `data.weight` in Word Cloud.
- Added feature, event ordering for controlling what handler runs first when multiple modules are used.
- Added new default behaviour for sunburst data labels, `rotationMode: 'auto'`. Now the best fit will be calculated. See #8502.
- Added support for polar parallel coordinate charts (star plots).
- Added symbol for month number without leading zero. Closes #8150.

## Bug fixes
- Fixed #4377, exporting context menu did not hide on button click.
- Fixed #8021, missing points after zoom in scatter 3d.
- Fixed #8031, columns overlapped xAxis.
- Fixed #8042, axis labels had the same slot width on 3d charts.
- Fixed #8140, series legend items didn't show up when `colorAxis.showInlegend` was false.
- Fixed #8159, useHTML caused that treemap data label was misplaced.
- Fixed #8163, added [xAxis.reversedStacks](https://api.highcharts.com/highcharts/xAxis.reversedStacks) option to control stacks order within a columns group.
- Fixed #8173, crosshair did not work properly with variwide.
- Fixed #8173, missing unit test.
- Fixed #8181, wordcloud missed large words.
- Fixed #8187, stackLabels in bar chart were misaligned.
- Fixed #8210, a regression causing axis labels to not expand after having ellipsis.
- Fixed #8214, missing space character before tracker class definition.
- Fixed #8234, a regression causing overlapping X axis labels on drilldown.
- Fixed #8241, use secure URLs in themes.
- Fixed #8243, the way of calculating axis slotWidth changed.
- Fixed #8245, regression causing [data.parsed](https://api.highcharts.com/highcharts/data.parsed) callback not being called on loading Google Spreadsheets.
- Fixed #8273, offline export bug due to nested function wrap.
- Fixed #8276, wrong z-index for halo in styled mode.
- Fixed #8277, missing top neck of reversed funnel.
- Fixed #8330, overlapping pie data labels due to a bug in the label distribution algorithm.
- Fixed #8358, export icon was not disabled using responsive rule.
- Fixed #8365, indicator calculated wrong values for long and short sma.
- Fixed #8377, chart disappeared after resizing a hidden chart inside a padded div.
- Fixed #8392, plotbands update zIndex issue.
- Fixed #8393, annotations are not exported when added dynamically.
- Fixed #8402, boost not rendering well with bubble chart and missing z values.
- Fixed #8406, colorAxis did not get new series extremes after chart update.
- Fixed #8407, scatter series added to a 3D chart via `chart.addSeries` was not converted to a `scatter3d` series.
- Fixed #8415, `className` option did not work on plot lines.
- Fixed #8428, pie chart slice did not show after visibility changes.
- Fixed #8438, combination charts from CSV didn't lay out properly without `seriesMapping`.
- Fixed #8444, axis title rendered a title tag when wrapped across two or more lines.
- Fixed #8456, improved 3d projection matrix property.
- Fixed #8467, regression causing long axis labels being clipped when using HTML in combination with `whiteSpace: nowrap`.
- Fixed #8477, plot line labels didn't work in browsers that support `Array.prototype.flat`.
- Fixed #8478, a regression causing duplicated legend items when using color axis and dynamically adding series.
- Fixed #8481, chart update with type: bar didn't work.
- Fixed #8494, incorrect assignment in data export for multiple pie charts.
- Fixed #8515, padding was not applied to data labels in sunburst series.
- Fixed #8531, random data labels in sunburst chart were hidden.
- Fixed #8181, regression with drilling up by clicking root node in Sunburst.
- Fixed build scripts which returned to early, instead of waiting for promise to resolve.
- Fixed disabling animation in pattern fills.
- Fixed export menu rendering below axis when scrollablePlotArea was used. See #8316.
- Fixed issue where image patterns could not have translucent opacity with default animation.
- Fixed issue with `scrollablePlotArea` being applied on exported charts. See #8316.
- Fixed issue with image patterns in IE not always being shown if images were cached.
- Fixed issue with initialValue was always supplied to reduce.
- Fixed scrollablePlotArea, the scroll jumped back to original `scrollPositionX` after toggling series. See #8316.
- Fixed stuck series labels.