# Changelog for Highcharts v6.1.2 (2018-09-03)

- Support for loading Highcharts as an [AMD module](https://github.com/highcharts/highcharts#load-highcharts-as-an-amd-module).
- Added parameter to [xAxis.labels.formatter](https://api.highcharts.com/highcharts/xAxis.labels.formatter) in addition to scope, allowing arrow functions as formatters. Closes #8580.
- Adjusted the threshold for when a contrasted data label turns white or black.

## Bug fixes
- Fixed #3589, inconsistent data label position in the waterfall series.
- Fixed #7097, rendering problem when animating 3D pie charts while hovering.
- Fixed #7484, update tooltip position when dragging and followTouchMove is enabled.
- Fixed #7649, error on 3d pie drilldown and drill up.
- Fixed #8024, empty gap in connector line in place of a null value.
- Fixed #8284, multiple markers did not follow points' positions when adding new points.
- Fixed #8355, error on running `Series.setData` on boosted series with the `updatePoints` parameter.
- Fixed #8506, refactored mapping data to appropriate bins in histograms. Closes #8646.
- Fixed #8529, not defining `series` in options for a 3D chart threw an error.
- Fixed #8532, hover color was ignored in sankey diagrams.
- Fixed #8561, legend keyboard navigation with `useHTML`.
- Fixed #8621, conditions extended in `getSlotWidth` wrap function.
- Fixed #8627, demo for legend navigation was not working correctly on Windows.
- Fixed #8633, implemented support for standard marker symbols in boost.
- Fixed #8638, legend with `proximate` layout was misplaced when all points were nulls.
- Fixed #8641, error on updating 3D chart when created empty.
- Fixed #8659, treemap child nodes were not clickable due to wrong animation of `fill` attribute to `none`.
- Fixed #8662, series names were random when `seriesMapping` object property had values more than 10.
- Fixed #8666, error in styled mode when trying to read a dataLabel style property.
- Fixed #8682, old sankey nodes were not destroyed when updating the series data.
- Fixed #8690, [plotOptions.vector.rotationOrigin](https://api.highcharts.com/highcharts/plotOptions.vector.rotationOrigin) not working properly.
- Fixed #8699, flags were missing in current time frame.
- Fixed #8704, the `useHTML` option did not take effect on rotated data labels, specifically on the sunburst series.
- Fixed #8708, print chart sometimes showed empty chart in Chrome when Boost was enabled.
- Fixed #8713, setting `cropThreshold` on a windbarb series broke the chart.
- Fixed #8731, boosted area displayed beyond pane when threshold was outside pane.
- Fixed #8742, glitch in stack label overlapping detection.
- Fixed #8768, missing ticks at the end of datetime axes if local system was in a half-hour time zone.
- Fixed #8773, background color of scrollable plot are was not extended, caused page background to bleed through.
- Fixed #8777, IE7 didn't display pie chart due to badly named `some` function.
- Fixed #8789, a regression causing the axis labels to take up too much space in some cases when using HTML.
- Fixed #8791, solid gauge didn't respect updating `colorIndex` on points.
- Fixed #8795, console errors when zoomed in and using `Series.setData` with redraw set to false.
- Fixed #8797, scrolling not available when scrollablePlotArea was combined with responsive options.
- Fixed #8809, a regression causing misplaced HTML axis labels after drilling down and up.
- Fixed #8818, shared tooltip in boost mode didn't always pick up all points.
- Fixed #8820, [chart.scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea) option didn't play well with [title.useHTML](https://api.highcharts.com/highcharts/title.useHTML) and other `useHTML` cases.
- Fixed #8824, make sure checkboxes stay fixed with [chart.scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea) enabled.
- Fixed #8830, orphaned data labels on points outside Y axis range on xrange series.
- Fixed #8834, exceptions on rendering stack labels on out-of-scale axis.
- Fixed #6794, 'cursor: pointer' wasn't working for data labels with 'useHTML: true'.

