# Changelog for Highcharts v7.0.0 (2018-12-11)

- Added [sonification](https://www.highcharts.com/demo/sonification) to the accessibility features.
- Added TypeScript support (Beta).
- Added [bubble legends](https://api.highcharts.com/highcharts/legend.bubbleLegend), legend items describing the scale of the bubbles.
- Added feature to match points by id when running setData.
- Added new series type [force directed graph or network graph](https://www.highcharts.com/demo/network-graph).
- Added new series type [packed bubble](https://www.highcharts.com/demo/packed-bubble).
- Added new series type [3D cylinder](https://www.highcharts.com/demo/cylinder).
- Added new series type [venn diagram](https://www.highcharts.com/demo/venn-diagram).
- Added new series type [column pyramid chart](https://www.highcharts.com/demo/column-pyramid).
- Added editor features for annotations, allowing annotations to be added, updated and removed through a GUI.
- Added debug module for making chart errors visible in the chart.
- Default exported chart name is now based on the chart title.
- Added option [chart.styledMode](https://api.highcharts.com/highcharts/chart.styledMode) to replace the previous separate build of styled mode files.
- Added options to align pie chart data labels to the edges of the chart.

## Upgrade notes
- If you use styled mode, the setup has changed. Instead of loading files from the `code.highcharts.com/js` folder, use the base JavaScript files, but set the [chart.styledMode](https://api.highcharts.com/highcharts/chart.styledMode) option to true.
- Polyfills are now needed for support in IE 6-8. Before including the `highcharts.js` file, load `modules/oldie-polyfills.js` in a conditional comment. Alternatively you can use your own polyfills or a third party library. See [System Requirements](https://www.highcharts.com/docs/getting-started/system-requirements#oldie).
- If the [chart.height](https://api.highcharts.com/highcharts/chart.height) setting is higher than the CSS height of the container, the chart will now be clipped. This is a consequence of adapting the chart to table cells and flex layouts.

## Bug fixes
- Corrected chart width for sub-pixel container width. Prevented overflow in flex-grids and table cells.
- Fixed #2617, wrong number of pages in legend with [legend.maxHeight](https://api.highcharts.com/highcharts/legend.maxHeight) in some cases.
- Fixed #5293, `pointBreak` event for broken-axis module was not working for columnrange series type in case highcharts-more was loaded before broken-axis module.
- Fixed #5857, drilling down column charts to more than the `cropThreshold` caused lost categories on the X axis.
- Fixed #8105, split tooltip header couldn't be removed by options.
- Fixed #8680, responsive rules were not applied on annotations.
- Fixed #8818, shared tooltips in boost with column series.
- Fixed #9046, force boost check now takes [plotOptions.series.visible](https://api.highcharts.com/highcharts/plotOptions.series.visible) into account.
- Fixed #9121, overlapping text labels with useHTML and styled mode.
- Fixed #9150, heatmap points were misplaced when using boost module without WebGL.
- Fixed #9156, export data download failed on iOS.
- Fixed #9197, no series animation on calling `Chart.update` with repeated options.
- Fixed #9200, errors in the console with small height and zones or negative colors.
- Fixed #9211, inverted heatmap in boost mode had wrong size when WebGL was disabled.
- Fixed #9226, Wrong number of series with indexex after update.
- Fixed #9247, console error on empty data labels in area range.
- Fixed #9248, on series hide/show yAxis extremes were not updated.
- Fixed #9252, added missing [annotations.id](https://api.highcharts.com/highcharts/annotations.id) documentation.
- Fixed #9258, remove use of id in default treemap data labels.
- Fixed #9270, series were removed from configuration options when invoking stock, map or gantt charts.
- Fixed #9278, drag and drop failing on mobile.
- Fixed #9289, avoid animating drilldown in wordcloud.
- Fixed #9291, correctly rounded default dataLablels for xrange series type.
- Fixed #9298, zooming problems with drag and drop.
- Fixed #9300, JS error when updating sankey series before it had been redrawn.
- Fixed #9301, regression in [tooltip.headerFormat](https://api.highcharts.com/highcharts/tooltip.headerFormat) for xrange series.
- Fixed #9375, invalid attribute on SVG elements in solid gauge series.
- Fixed #9400, tooltip box border issues when defining font size inline.
- Fixed #9410, when using step in boost, the first point was wrong.
- Fixed #9481, annotations attached to hidden points were visible.
- Fixed #9485, selected state was not preserved after drilling down and up.
- Fixed #9487, category axis didn't update when more data than the `cropThreshold`. Closed #6926.
- Fixed #9504, some links rendered broken on inverted Sankey diagram.
- Fixed #9525, wrong number of points after update zoomed chart.
- Fixed #9533, printing chart via the export menu failed when `scrollablePlotArea` was active.
- Fixed #9537, ellipsis not applied to X axis labels when `useHTML` was true.
- Fixed #9562, wrong categories and data to axis mapping with `uniqueNames` and drilldown.
- Fixed #9565, dot delimiter on dates in CSV caused the format deduction to fail.
- Fixed #9618, `setExtremes` should trump `axis.ceiling`.
- Fixed #9623, 3D pie chart didn't hide when rendering inside a div with `visibility: hide`.
- Fixed #9166, off-screen markers clamped to plot width in boost.
- Fixed #9206, draggable points did not work with dynamic series.
- Fixed issue with a11y module sometimes throwing exception on init.
