# Changelog for Highcharts v7.0.2 (2019-01-17)

- Added [jitter feature](https://api.highcharts.com/highcharts/plotOptions.scatter.jitter) to scatter plots.
- Added feature to set [legend.width](https://api.highcharts.com/highcharts/legend.width) as a percentage, and restrain the default width to 50% for legends at the sides of the chart.
- Added [overlap stacking](https://api.highcharts.com/highcharts/plotOptions.waterfall.stacking) to waterfall charts.


## Bug fixes
- Fixed #6817, point click event didn't fire on the first touch.
- Fixed #7253, long legend titles were not wrapped, pushing the legend out of the chart.
- Fixed #7860, `pointPlacement` was not implemented for heatmap.
- Fixed #8160, treemap data labels overflowed on long words.
- Fixed #9617, chart update in responsive mode caused some of the responisve options noneffective.
- Fixed #9685, maximum call stack exceeded in venn diagrams in certain cases.
- Fixed #9694, tooltip was clipped when using the `outside` option and different series types.
- Fixed #9709, missing values when exporting data in venn.
- Fixed #9718 and #9768, incorrect overlap calculations in venn diagrams in some cases.
- Fixed #9728, incorrect handling of negative Z values in bubble chart styled mode.
- Fixed #9747, a regression causing upper area range data labels to get stuck after redrawing.
- Fixed #9749, memory building up and animation deferred on hidden pages.
- Fixed #9758, no-data module was ignoring boost points.
- Fixed #9761, X axis labels overlapped on polar chart with dense categories.
- Fixed #9762, series was referencing public object for `userOptions` and some updates were working in an unexpected way.
- Fixed #9779, rendering bug in svg2pdf.js caused filled rectangles in offline-exported PDF.
- Fixed #9794, wordcloud series didn't support state options.
- Fixed #9798, added ability to change options for particular link and improved nodes docs for networkgraph series.
- Fixed #9801, networkgraph was not compatible with no-data module.
- Fixed #9803, networkgraph throwing maximum call stack error with cyclical links.
- Fixed #9815, performance problem with series labels.
- Fixed #9818, bad rendering of sankey chart with unordered data.
- Fixed #9835, axis disappeared on rotating labels 180 degrees.
- Fixed #9841, a regression causing the Y axis to shrink in certain cases when setting `xAxis.tickAmount`.
- Fixed #9841, `tickAmount` axis option wasn't properly supporting false values for `startOnTick` and `endOnTick`.
- Fixed #9849, improved line height handling with non-pixel font-size units.
- Fixed #9861, error when updating the X value of data points that had an ID.
- Fixed #9869, tooltip on xrange series type was having misplaced point anchor due to some xAxis options. Closes #9727.
- Fixed #9871, a regression causing the chart width to be miscalculated when the container had a transform.
- Fixed an issue in series-label placement logic, labels gravitated to the right.
