# Changelog for Highcharts v7.1.0 (2019-04-01)

- Added [Organization Chart](https://www.highcharts.com/docs/chart-and-series-types/organization-chart) series type.
- Added [Item Chart](https://www.highcharts.com/docs/chart-and-series-types/item-chart) series type for visualizing item counts and parliaments.
- Added [Dependency Wheel](https://www.highcharts.com/docs/chart-and-series-types/dependency-wheel) series type.
- Added [Timeline](https://www.highcharts.com/docs/chart-and-series-types/timeline-series) series type.
- Added [3D Pyramid](https://www.highcharts.com/docs/chart-and-series-types/pyramid-3d) and [3D Funnel](https://www.highcharts.com/docs/chart-and-series-types/funnel-3d) series types.
- [Accessibility](https://www.highcharts.com/docs/accessibility/accessibility-module) - improved experience for screen reader users, support for dynamic data and drilldown, as well as support for voice input software.
- Added `inactive` states to series and points, allowing other series to be dimmed when the user is hovering the data or legend. To bring back the old series dimming behavior, set [plotOptions.series.states.inactive.opacity](https://api.highcharts.com/highcharts/plotOptions.series.states.inactive.opacity) to 1.
- Added [levels](https://api.highcharts.com/highcharts/plotOptions.sankey.levels) to sankey series.
- Added `annotation.events`: `add`, `afterUpdate` and `remove`.
- Added full screen capabilities to exporting module.
- Added option [series.treemap.events.setRootNode](https://api.highcharts.com/highcharts/series.treemap.events.setRootNode).
- Added option [xAxis.margin](https://api.highcharts.com/highcharts/xAxis.margin) to ensure a distance between multiple axes on the same side.
- Added options [plotOptions.sankey.borderWidth](https://api.highcharts.com/highcharts/plotOptions.sankey.borderWidth) and `sankey.borderColor` for sankey nodes.
- Added force directed algorithm for improved packing of packed bubble charts.
- Added support for [nested packed bubbles](https://jsfiddle.net/gh/get/library/pure/highcharts/highcharts/tree/master/samples/highcharts/demo/packed-bubble-split/).
- Added [Verlet integration](https://api.highcharts.com/highcharts/series.networkgraph.layoutAlgorithm.integration) for network graphs. Generally improved network graph algorithms.
- Added data labels to links in network graphs.

## Upgrade notes
- Changed default X axis [tickWidth](https://api.highcharts.com/highcharts/xAxis.tickWidth) option. Now tick marks are not rendered by default on category axes. Set the `tickWidth` to 1 to bring back the old behaviour.
- Renamed [plotOptions.treemap.drillUpButton](https://api.highcharts.com/highcharts/plotOptions.treemap.drillUpButton) to `traverseUpButton`.
- The new `inactive` state makes other items dim when hovering a series. To bring back the old series dimming behavior, set [plotOptions.series.states.inactive.opacity](https://api.highcharts.com/highcharts/plotOptions.series.states.inactive.opacity) to 1.

## Bug fixes
- Fixed #10009, wrong tooltip size with `useHTML` and varying text lengths.
- Fixed #10010, `series.update` destroyed points and lost their event handlers.
- Fixed #10031, long dataLabels for pie with `useHTML: true`, were generated with width less than 0.
- Fixed #10052, chart printing failed with error on IE11.
- Fixed #10055, exporting custom annotation did not work for other types than SVG.
- Fixed #10063, proximate legend layout did not account for axis `top` setting.
- Fixed #10081, chart with `parallelCoordinates` was not resizing properly after update.
- Fixed #10082, points below Y axis min in polar charts were drawn incorrectly.
- Fixed #10101, bubble legend was duplicated with map module.
- Fixed #10106, issue with the `showEmpty` feature.
- Fixed #10107, legend navigation required overly precise clicks/touches.
- Fixed #10115, vector and wind barb series didn't handle the `clip` option.
- Fixed #10127, treemap removed old `classNames` on update.
- Fixed #10131, error in draggable points after updating series.
- Fixed #10160, stacking null points from the same series threw unhandled exception.
- Fixed #10163, `series.setData()` did not remove old nodes for a networkgraph.
- Fixed #10167, a regression causing unwanted padding on top of legends in some cases.
- Fixed #10187, `setData` didn't update data when old data had null values and the same length.
- Fixed #10213, relative chart height didn't apply in responsive chart.
- Fixed #10220, visible parts on charts inside an element with `visibility: hidden`.
- Fixed #10225, histogram produced additional bin on the end.
- Fixed #10232, solid gauge series had wrong legend symbol.
- Fixed #10243, offline export failed with boost and hidden series.
- Fixed #10246, boost culling issue.
- Fixed #10265, class names were applied multiple times to elements, causing selected pies not to unselect after redraw.
- Fixed #10273, changing live data settings dynamically didn't take effect.
- Fixed #10282, overlap larger than smallest circle in venn diagrams.
- Fixed #10283, click events were not applied on scatter points with base tag present in Firefox.
- Fixed #10286, responsive setting of `showInLegend` failed.
- Fixed #10302, plot line events did not fire if the lines were initially outside visible range.
- Fixed #10312, keyboard navigation with no data.
- Fixed #10342, HTML split tooltip did not fade after series update if formatter returned a string.
- Fixed #10347, annotation-bindings were not compatible with IE11.
- Fixed #10352, replaced `Math.sign()` in networkgraph source code for IE compatibility.
- Fixed #10417, simulation for packed bubble series did not stop when exporting chart.
- Fixed #6234, some presentational options were not settable in zones in column series.
- Fixed #6404, plot band labels were not aligned correctly in gauge chart.
- Fixed #6894, [yAxis.softMax](https://api.highcharts.com/highcharts/yAxis.softMax) didn't take effect on the other side of the zero plane.
- Fixed #7048, tooltips didn't appear on null values in heatmap when in boost mode.
- Fixed #7895, renamed and documented option in export-data module responsible for series data visibility in exported chart data - includeInDataExport.
- Fixed #8766, chart crashed when misconfiguring `plotOptions`.
- Fixed #8864, `connectorColor` didn't work for individual points.
- Fixed #9087, malformed exported SVG when SVG elements were added inside `useHTML` labels.
- Fixed #9128, #10025, histogram series had incorrect amount of free space between points.
- Fixed #9233, data labels and tooltip formatting was not supported for null points in heatmap.
- Fixed #9880, hover animation on xrange points was incorrect.
- Fixed #9917, `chart.update` with initial pane options did not change the pane.
- Fixed #9962, line series was not rendered in the boost mode, when all points were outside the extremes.
- Fixed #9978, horizontal scrollbar on RTL charts with a11y module.
- Fixed #10161, wrong extremes in single category axis.
