# Changelog for Highcharts v7.1.2 (2019-06-03)

- Added new feature, vertically scrollable plot area. This adds native scrolling features vertically, and is enabled using the [chart.scrollablePlotArea.minHeight](https://api.highcharts.com/highcharts/chart.scrollablePlotArea.minHeight) setting.
- Deprecated the `labels` option in favor of `annotations`, see #10429.
- Added stack labels feature to waterfall series (#3165).
- Added auto alignment for solid gauges with two labels, see #10635.
- Improved performance for exporting packedbubble series.
- Added `series.nodes[index].remove()` method to networkgraph series to remove a node with all connected links. See #10565.
- Added support for percentage value in [yAxis.labels.distance](https://api.highcharts.com/highcharts/yAxis.labels.distance) option for gauge series. See #10587.

## Bug fixes
- Fixed #9269, problems with grid axis update. Modified the columns logic in `GridAxis` to only add one column (the master) to the public axes array, and the remaining to an internal columns array.
- Fixed issue with wrong clipping of inverted scrollable plot area (see #10786).
- Fixed #8607, tooltip was masked at the edges of the chart when [chart.scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea) was active. Changed the [tooltip.outside](https://api.highcharts.com/highcharts/tooltip.outside) option to default to true when using scrollable plot area.
- Fixed #10741, overlapping networkgraph points were dissappearing.
- Fixed #8417, stacked columns were overlapping after update to 3D.
- Fixed #9396, could not disable series label animation. Animation is now set to 20% of `series.options.animation` duration initially, and equal to `chart.options.animation` on updates.
- Fixed issue with sorting of events when `addEvent` was called with parameter `options.order` value of `undefined`.
- Fixed #3881, [plotOptions.series](https://api.highcharts.com/highcharts/plotOptions.series) trumped `plotOptions[type]` in chart instance options.
- Fixed #10669, sunburst didn´t show error when duplicate point id's were used.
- Fixed #8897, 3D columns were not visible when first series was initially hidden.
- Fixed #10491, responsive rules were ignored when \`colorAxis\` updated.
- Fixed #10737, exporting sunburst's data to CSV did not include points with the same name.
- Fixed #10713, initializing annotations in responsive rules didn't work.
- Fixed #9198, zones and negative color were not applied after `series.setData`.
- Fixed #10712, solid gauge data labels rendered below center by default. They are now vertically centered. Changed `dataLabels.y` default to 0.
- Fixed #10715, column collapsed after drilldown when the X axis labels became longer.
- Fixed issue with accessibility features not working for series without markers.
- Fixed #10696, sometimes series animation was missing when updating points via `Series.setData()`.
- Fixed #10361, a regression causing clipping of the export menu below the chart.
- Fixed #10646, [plotOptions.column.minPointLength](https://api.highcharts.com/highcharts/plotOptions.column.minPointLength) drew zero points as negative.
- Fixed #10062, packed bubble series ignored `lang.thousandsSep`.
- Fixed #10630, null point was drawn in solid gauge.
- Fixed issue where accessible proxy buttons were wrongly positioned in some browsers.
- Fixed #10625, `setData()` in networkgraph series caused simulation to run from the initial state.
- Fixed #10637, the accessibility module increased the chart size.
- Fixed #10624, updating sankey while hovering a link caused errors.
- Fixed #10633, panning on mobile devices did not work when [xAxis.max](https://api.highcharts.com/highcharts/xAxis.max) or [xAxis.min](https://api.highcharts.com/highcharts/xAxis.min) options were set.
- Fixed #10628, adding annotations in chart's callback threw errors.
- Fixed #10572, `dataRefreshRate` didn't work properly for Google Spreadsheets.
- Fixed #10574, `connectNulls` could not be disabled in area with `percent` stacking.
- Fixed #10536, setting time on a chart instance altered global time.
- Fixed #10571, split tooltip didn't change stroke color while hovering when points in a single series had different colors.
- Fixed #10569, regression that caused missing series line after removing zones.
- Fixed #10516, extreme large zoom in Chrome did not render yAxis labels after zooming out.
- Fixed #10482, enhancement demo to adding points and lines.
- Fixed #10540, pie series did not animate slices when toggling legend items.
- Fixed #10545, `networkgraph.dataLabels.linkTextPath` did not remove artifical border around label.
