# Changelog for Highcharts v7.2.1 (2019-10-31)

- Added feature to draw plot lines on radial axes from the inner to the outer radius of the main pane.
- Added support for combining [tooltip.split](https://api.highcharts.com/highcharts/tooltip.split) and [tooltip.outside](https://api.highcharts.com/highcharts/tooltip.outside).

## Bug fixes
- Fixed #12222, empty pie series showing `lineWidth` after hover.
- Fixed #12223, animating halo for a slice in pie series used to throw errors.
- Fixed  #12243, fill property on pattern fills was applied to the wrong element. Introduced new option, `pattern.backgroundColor`.
- Fixed #11644, extremes in color axis were incorrect when using tilemap series with very small values.
- Fixed #11738, updating treemap series with the same amount of points caused cells to disappear.
- Fixed #11650, added missing `highcharts-tooltip-header` classname to the tooltip's header.
- Fixed #12073, dragging an annotation used to change points' values too.
- Fixed #7559, error when updating a waterfall with first data value as sum or intermediate sum.
- Fixed #11776, data labels were not visible in 3D Column series.
- Fixed #12055, overlapping legend items when combining `layout: 'proximate'` and `useHTML: true`.
- Fixed #12064, redundant spaces separating class names in SVG class attributes.
- Fixed #12033, error when toggling stacking on area series with nulls.
- Improved screen reader compatibility for chart export menu.
- Fixed #11727, logarithmic yAxis with just one label sometimes was rendered with numerical errors.
- Fixed #11956, `pointPlacement` did not work for columns with just one category.
- Fixed #11955, incorrect point positions on inverted chart, when [series.pointPlacement](https://api.highcharts.com/highcharts/plotOptions.series.pointPlacement) was set to `between`.
- Fixed #11966, using `chart.setTitle()` on a chart with `scrollablePlotArea` misplaced the title.
- Fixed #11510, points with a relatively very small `z` value were not displayed in a variwide chart.
- Fixed #11970, annotation's `drag` event was not fired.
- Fixed #11753, invalid label placement broke venn diagrams in certain scenarios.
- Fixed #11100, 3D columns were not animated on data update.
- Fixed #11476, inverted variwide chart with disabled X axis labels threw an error.
- Fixed #11801, dragging annotations did not prevent zooming in.
- Fixed #11897, combination of pie series and polar chart with panes threw an error.
- Fixed #11405, plotLines were rendered outside the bottom and left chart edge if the value was the same as the axis extreme.
- Fixed #11690, removed use of undefined global variable that broke support for ES modules.
- Fixed #11812, point colors were not changed if `colorAxis` was added in update.
