# Changelog for Highcharts v8.0.1 (2020-03-02)

- Added new option for polar charts, [pane.innerSize](https://api.highcharts.com/highcharts/pane.innerSize).
- Removed the experimental "Open in Highcharts Cloud" menu item of the export-data module.
- Added pie series `dataLabel` x and y position per point, see #12985.
- Added new option [annotations.labelOptions.accessibility.description](https://api.highcharts.com/highcharts/annotations.labelOptions.accessibility.description).
- Added accessibility functionality for annotations. Also added new option [accessibility.point.valueDescriptionFormat](https://api.highcharts.com/highcharts/accessibility.point.valueDescriptionFormat).
- Added support for `useHTML` property to rotated data labels.
- Changed the default `inactive.opacity` for venn diagrams to ease perception, see #10663.
- Added new option `pattern.patternTransform` that allows SVG `patternTransform` functions on a pattern.
- Fullscreen module added. Allows using the `chart.toggleFullscreen()` method.
- Automatically dismiss popup content, such as tooltips, when user presses ESC key.
- Changed the behavior of keyboard navigation. It no longer opens export menu automatically, but sets focus to the button.
- Improvements to sonification.
- Introduced the new options [plotOptions.series.custom](https://api.highcharts.com/highcharts/plotOptions.series.custom), [series.custom](https://api.highcharts.com/highcharts/plotOptions.series.custom), and `series.data.custom` to store additional data for custom formatters and custom event callbacks.

## Upgrade notes
- The [Highcharts.Color](https://api.highcharts.com/class-reference/Highcharts.Color) constructor will not work without the `new` keyword. Use either `new Highcharts.Color` or the `Highcharts.color` factory.

## Bug fixes
- Fixed wrong `x-range` drag handles issue with multiple series, see #12878.
- Fixed #12934, responsive rules didn't work for drill-up button initially.
- Fixed #12949, using multiple drilldown with data sorting threw an error.
- Fixed tooltip position on sankey diagram links and nodes when `tooltip.followPointer` was `false`.
- Fixed #12926, dumbbell marker was incorrectly colored after mouse out when [series.marker.fillColor](https://api.highcharts.com/highcharts/plotOptions.series.marker.fillColor) was defined.
- Fixed #11917, errors and failed rendering of sankey chart if the number of nodes was too great. Fixed by reducing the [nodePadding](https://api.highcharts.com/highcharts/plotOptions.sankey.nodePadding) below its setting to allocate space for all nodes.
- Added new option, [annotations.shapes.src](https://api.highcharts.com/highcharts/annotations.shapes.src), see #12890.
- Fixed issues with tooltips and scrollable plot area. See #12416 and #12498.
- Fixed #11993, wordcloud looked incorrect after running `setData()`.
- Fixed #12566, in the data module, empty points should be parsed to `null` instead of `undefined`.
- Fixed #12812, high contrast mode not detected in new Edge.
- Fixed #12666, node render to null increase the sum by set weight.
- Fixed #12514, data label position for column pyramid with 0 value.
- Fixed issue with wrong axis options after `drilldown` to treemap series, see #12326.
- Fixed #10162, RTL text was covered when using a text outline.
- Fixed issue with updating legend's font-size, see #12705.
- Fixed issue with pie series update to 3d, see #12714.
- Fixed #11148, a point should not be trackable when is out of his pane. Also, isInsidePlot() works for panes now.
- Fixed #12718, markers invisible on chart update from null points with a11y module.
- Fixed #12690, a11y module caused render issues for 3D funnel.
- Fixed issue with not visible column data label when a point has a small value, see #12688.
- Fixed #12711, missing border and background for split tooltip's header in styled mode.
- Fixed #12513, deselecting previously selected nodes did not work for networkgraph series.
- Fixed #12156, added `series.inactive.enabled` option to disable inactive state.
- Fixed #12453, node with 0 value was rendered on the Sankey and dependency wheel.
- Fixed #12424, enabling network graph series in legend used to throw errors.
- Fixed #12515, updating depth in 3D pie chart did not work.
- Fixed #4369, 3D columns had wrong zIndex with long charts.
- Fixed issue with disabled animation for empty pie, see #12619.
- Fixed issue with tooltip wrong position on a bar chart when `xAxis` top or height set, see #12589.
- Fixed #12648, datetime axis ticks were wrong in Indian time zone when close to the DST crossover.
- Fixed #12627, legend items in pie chart overlapped on drilldown.
- Fixed #5508, data labels were wrongly positioned on inverted 3D charts.
- Fixed #12484, drag markers for columns were not showing when `highcharts-3d` and `draggable-points` were loaded.
