# Changelog for Highcharts v8.1.0 (2020-05-05)

- Added vertical panning to Highcharts. The `chart.panning.type` now accepts `y` directions.
- Added box options for `yAxis.stackLabels`: `backgroundColor`, `borderWidth`, `borderRadius` and `borderColor`. See #13330.
- Added new series label options, `series.label.format` and [series.label.formatter](https://api.highcharts.com/highcharts/plotOptions.series.label.formatter).
- Added individual dash style settings for various parts of box plots. See #13065.
- Added language options for export-data table text, see #13166.
- Added ability to set markers of heatmap points to a custom shapes defined within `SVGRenderer.prototype.symbols` object, see #12508.

## Upgrade notes
- The Axis class was refactored as part of the TypeScript migration. Axis extensions like log axis, broken axis, parallel axis, datetime axis and ordinal axis are now handled as compositions. Instead of adding multiple properties to the main axis instance, they now add a single object that holds all properties. This does not affect the options API, but it may affect implementations that are based on some of our samples that used the original properties. Our samples have been updated to use the new structure.
- For added type safety, we are now defining SVG path definition as two-dimensional arrays, or in TypeScript sense an array of tuples. So `['M', 0, 0, 'L', 100, 100]` in the new implementation should be written `[['M', 0, 0], ['L', 100, 100]]`. We built in a converter for old paths, but there may be cases, like for example directly accessing `SVGRenderer.crispLine`, where it breaks.

## Bug fixes
- Fixed issue with missing accessibility options in the API.
- Fixed #12767, exported data table had wrong points categories.
- Fixed #13305, focus border not updated with scrolling points.
- Fixed #11500, stack labels had a wrong position after moving X axis or Y axis.
- Fixed #13332, 3D column not working on IE browsers. Fixed `fillSetter` in cuboid methods.
- Fixed #13310, HTML tooltip did not stick on pointer contact when activated.
- Fixed #13136, couldn't set `yAxis.tickAmount` when the chart size was small.
- Fixed #13098, wordcloud animation options didn't work.
- Fixed #12656, drilldown points were wrong after click on axis label.
- Fixed #13204, multiple `yAxis` labels were not centered over the gridlines when rotation was set and `alignTicks` was enabled.
- Fixed #8280, 3D column `zIndex` was wrongly calculated on wide screens.
- Fixed #13101, pie with negative values threw error on drilldown.
- Fixed #13226, tooltip prevented interaction on other chart elements.
- Fixed #13169, a regression causing packed bubble's initial simulation not to work smoothly.
- Fixed #12163, width of button was not updated when the font weight changed. Also fixed #12165, errors on setting the button width to `null`.
- Fixed #13161, stacking was erroneously applied on xrange.
- Fixed #5999, `point.color` was not respected for boosted series.
- Fixed #13134, lollipop misaligned on errorbar series.
- Fixed #12979, console errors when updating an axis at the same time as updating a related annotation.
- Fixed #11928, 3D pie was misplaced after calling `Series.update`.
- Fixed #13110, `chart.sonify` was no longer working after v8.0.1.
- Fixed #13069, histogram produced the wrong number of bins when `baseSeries` was filled by points with negative values.
- Fixed #12027, print was not working correctly in packed bubble charts.
- Fixed #12991, [scrollablePlotArea.minHeight](https://api.highcharts.com/highcharts/chart.scrollablePlotArea.minHeight) was not responsive when changing window height.
- Fixed #13100, in organization charts, node data labels disappeared in some cases.
- Fixed #12883, legend pagination was not working correctly when the accessibility module was included.
- Fixed #13001, `scrollablePlotArea` not inheriting chart style. Also applied chart styles to tooltip container when [tooltip.outside](https://api.highcharts.com/highcharts/tooltip.outside) is `true`.
- Fixed #13070, annotation was not draggable when HTML label was used.
- Fixed #13077, the `point.isInsidePlot` method didn't handle polar charts.
- Fixed #11635, scrolling didn't trigger hiding of the tooltip when the cursor left the chart's container.
- Fixed #12091, could not update series shadows without disabling them first.
- Fixed #12994, [tooltip.hideDelay](https://api.highcharts.com/highcharts/tooltip.hideDelay) of 0 was causing unexpected tooltip behavior.
- Fixed #11397, incorrect position of the focus border on text elements.
- Fixed issue with crosshair wrong position with shared tooltip, see #13002.
