# Changelog for Highcharts v8.1.1 (2020-06-09)

- Added new option,  [plotOptions.column.centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory). It centers columns within each category group, but avoiding gaps for `null` or missing points.
- Added deprecation error handling.
- Added support for selecting and dragging `parentNode` in the packed bubble series. See #11782.

## Bug fixes
- Fixed #13559, no JavaScript execution should be allowed from chart configuration strings, except from callbacks like event handlers and formatters. This prevents JavaScript from being injected from forms and other inputs relaying directly to text properties in the chart config.
- Fixed #13541, `chart.update` with `oneToOne` failed when removing and adding series, if all series had explicit id's.
- Fixed issue with JS errors and malfunction on drill-up button on touch devices when the accessibility module was loaded.
- Fixed #12804, in sunburst charts, the drill-up button was visible after drilling up to the top level.
- Fixed #13554, a11y not supporting proximate legend layout.
- Fixed #13534, dragging points caused an error on iOS.
- Fixed #13369, edge case where ticks were different after changing series visibility.
- Fixed #13293, added the X value in exported data table if the point had defined name and `xAxis` was not a category type.
- Fixed #13590, CSS classes not being removed correctly, causing unwanted behaviour in pie chart hovering and unhovering.
- Fixed #13309, PDF exports always having landscape orientation when using the `offline-exporting` module.
- Fixed #13574, packed bubble size changed when other series were added.
- Fixed #13372, `drilldown` in horizontal item series was not allowed.
- Fixed #13420, adding annotation was not working on iOS devices.
- Fixed #13202, the lollipop series didn't work with all data formats.
- Fixed #13371, unable to display data labels in item series without setting series size.
- Fixed #12077, histogram long decimals crashed browsers.
- Fixed #13342, tooltip tracking was broken after height update.
- Fixed #13379, item series with no data threw an error.
- Fixed #12569, point hover state was lost when axis updated.
- Fixed #11501, 3D pie was not correctly exported to PDF with offline export.
- Fixed #13071, unnecessary network request in IE11.
- Fixed #13489, `Chart.print()` was not working correctly with `highcharts-more.js` (specifically network graphs) included.
- Fixed #13482, unable to disable markers in styled mode with a11y.
- Fixed #13463, closing export menu using ESC key should not move focus.
- Fixed #11750, [series.opacity](https://api.highcharts.com/highcharts/plotOptions.series.opacity) option was not respected when creating or updating series.
- Fixed #13308, empty space appeared on top and bottom of sankey chart when using the [minLinkWidth](https://api.highcharts.com/highcharts/plotOptions.sankey.minLinkWidth) option.
- Fixed #13375, events were not added to dynamically created plot bands and lines.
- Fixed #13421, animation was fired when zooming boosted series.
- Fixed #13353, item series - when rendered in a full circle, points overlapped.
