# Changelog for Highcharts v8.2.0 (2020-08-20)

- Internally reorganized source file structure and naming.
- Added `defer` as animation parameter, see #12901. This allows for granular deferring of series animation, labels etc.
- Added toggle feature for the data table in the `export-data` module. See #13690.
- Added support for configuring sonification options in the chart configuration, as well as support for disabling individual series, configuring master volume, and inverted polarity mapping. Note that chart configuration options are still considered experimental and may change.
- Added new option, [time.moment](https://api.highcharts.com/highcharts/time.moment), allowing the `moment.js` library to be used without being available in the window context.

## Upgrade notes
- The file structure of ES modules has changed. This has no consequences when using master files as advised (like [http://code.highcharts.com/es-modules/masters/highcharts.src.js](http://code.highcharts.com/es-modules/masters/highcharts.src.js)), but may break when loading module files directly.

## Bug fixes
- Fixed #13694, threshold wasn't respected when `low` was defined.
- Fixed #13553, exception on negative X values on logarithmic axis.
- Fixed #13737, a regression causing chart zoom to conflict with the browser's drag-and-drop behaviour.
- Fixed #13710, a regression causing errors on empty pie series.
- Fixed #13726, `img` and `br` tags in data labels not being proper XHTML on SVG export.
- Fixed #13538, `softThreshold` not working as expected when a `threshold` was set.
- Fixed #10555, `scrollablePlotArea` not rendering correctly on FireFox.
- Fixed #12959, #13937, drilldown did not work on treemap and sunburst series after update.
- Fixed #13789, incorrect arearange path on polar chart when the [connectEnds](https://api.highcharts.com/highcharts/plotOptions.series.connectEnds) option was set to false.
- [object Object].
- Fixed #13736, draggable annotations did not work on touch devices.
- Fixed #13707, view table link should be a button.
- Fixed #13864, better accessible legend item labels.
- Fixed #13729, focus issues with shift+tab.
- Fixed #13971, missing Series imports preventing some builds from the Download Builder to work.
- Fixed #13532, a regression in 8.1.0 causing annotations of type "label", "circle" and "rectangle" not to be editable.
- Fixed #13762, missing `xAxis` labels on a polar chart when the `useHTML` option was set to true.
- Fixed #13846, data labels were initially hidden in some pie chart instances due to overlapping detection.
- Fixed #12868, drag zoom was not working on multiple charts after scrolling.
- Fixed #13785, wrong CSV output for data without defined `y` value.
- Fixed #13771, polar chart tooltip was hidden when point value was equal to max.
- Fixed #13570, updating chart and networkgraph series simultaneously threw errors.
- Increased precision of sonification duration.
