# Changelog for Highcharts v9.0.0 (2021-02-02)

- Improved security by filtering all HTML configuration strings and abstract syntax trees through allow lists before inserting into the DOM.
- Added support for area series in 3D charts.
- Added new feature [chart.zoomBySingleTouch](https://api.highcharts.com/highcharts/chart.zoomBySingleTouch) to provide optional mouse-like selection zooming for touch devices. See #14775.
- Added accessibility support for legend title #(14872) and provided more intuitive legend item labels for assistive technology (#14837).

## Upgrade notes
- Due to improved security, some tags or attributes may be removed from HTML configuration options like labels or tooltip formats and formatters. Read more [in the docs](https://www.highcharts.com/docs/chart-concepts/labels-and-string-formatting#filtering) on how to allow them.

## Bug fixes
- Fixed #14138, tooltip was displayed outside `plotArea` for columns when they were exceeding `yAxis` extremes.
- Fixed #13490, point hovering effects such as `tooltip` stopped working after disabling [chart.polar](https://api.highcharts.com/highcharts/chart.polar) with [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #10322, limit local timezone to timestamps without timezone.
- Fixed #14910, [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) broke after zooming twice.
- Fixed #8095, reset zoom button was not visible after drilldown.
- Fixed #14893, removed misleading default value in the `labels.format` docs.
- Fixed #11494, setting `z-index` on tooltip with [outside](https://api.highcharts.com/highcharts/tooltip.outside) set to `true` through chart options was not possible.
- Fixed #14351, `solidgauge` pane flickered on [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #14771, incorrect tooltip position on inverted chart with adjusted axis width.
- Fixed #14053, plot bands added before [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update) with [redraw](https://api.highcharts.com/highcharts/chart.events.redraw) set to `false` were not added when dynamically adding plot bands between the [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update) and a [redraw](https://api.highcharts.com/highcharts/chart.events.redraw).
- Fixed #14148, `waterfall` chart with reversed `yAxis` rendered wrong stacking connectors.
- Fixed #14209, histogram after `setData` with empty array wasn't updated.
- Fixed #14876, `minPointLength` columns did not show for series with only zero values when combined with series with only negative values.
- Fixed #14834, `colorAxis` ignored `reversed` option set in chart config on [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #14793, Z axis broke on [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #14833, column series axis breaks did not render correctly.
- Fixed #14283, problems with dynamically updating the color axis `visible` property.
- Fixed #14858, left and right-aligned callout labels with the anchor above or below sometimes missed anchor lines when there was no room for a chevron.
- Fixed #13220, #12788, #12489, #11975, wrong pointer position after changing size or scale on a parent element. `Chart.reflow` now needs to be called after scale changes and `Chart.updateContainerScaling` has been removed.
- Fixed #14305, original chart options got mutated on [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #14830, exporting waterfall chart with stack labels and hidden series threw.
- Fixed #8635, zooming variwide chart did not work.
- Fixed #8742, some `stackLabels` did not render with `dataLabels` enabled.
- Fixed #8795, hovering the chart after zooming in and using `setData` with [redraw](https://api.highcharts.com/highcharts/chart.events.redraw) set to `false` threw.
- Fixed #14549, incorrect clip-path for added axis.
- Fixed #13283, an issue with the data module's CSV parser. Hex colors (and any other strings following a hash) were treated as a comment and ignored.
- Fixed #14769, axis label formatter was called with NaN values when the axis was short and series consisted of only null values.
- Fixed #13996, #13488, pointer position was wrong after chart element was scrolled inside another element.
- Fixed #14773, [styledMode](https://api.highcharts.com/highcharts/chart.styledMode) pie series not updating color correctly second time.
- Fixed a11y issue with absolute positioning, touches #14090.
- Fixed the initialization of `Time.variableTimezone`, it caused `Time` to sometimes return the wrong time when `useUTC` was set to `false`.
- Fixed #14623, `Point.colorIndex` did not pick up `Series.colorIndex` updates.
- Fixed #14584, setting `dataLabels.allowOverlap` to `false` did not work properly for sankey series.
- Fixed #14624, [panning.type](https://api.highcharts.com/highcharts/chart.panning.type) enabled panning while `panning.enabled = false`.
- Fixed #14649, dynamically updating visual attributes on points in flag series did not work.
- Fixed #14637, setting `pointPlacement` to `between` placed line series points on ticks instead of between them.
- Fixed #14315, setting X axis extremes outside the chart series' data range threw.
- Fixed #14246, pie point stayed hidden after first legend item click when `ignoreHiddenPoint` was set to `false`.
- Fixed #14236, stacked area chart did not render correctly with the `broken-axis` module loaded and a [gapSize](https://api.highcharts.com/highcharts/plotOptions.series.gapSize) greater than `0`.
- Fixed #13948, exported PDFs containing linear gradients with multiple 0 offset stops had errors.
- Fixed #13961, `datetime` axis had missing ticks when `Chart.time` had half-hour `timezone` or `timezoneOffset` set.
- Fixed #13804, 3d pie animation in inactive tab threw.
- Fixed #13716, annotations added in responsive rules did not work.
- Fixed #14746, column chart with null data, datetime axis and `useUTC` set to `false` threw.
- Fixed #14765, `Highcharts.patterns` global was missing.
- Fixed #14444, boosted inverted chart had wrong clip-path.
- Fixed #14244, tooltip in column-based series with multiple `xAxis` had wrong position.
- Fixed #14362, no animation when a series was added dynamically.
- Fixed #14426, it was not possible to pan vertically to 0 after zooming.
- Fixed #14458, drilling down 3d chart points with the same name threw.
- Fixed #14425, last histogram bin sometimes had inaccurate x2.
- Fixed #14417, charts displayed parts of the data when min or max exceeded extreme values.
- Fixed #14397, `networkgraph` simulation restarted on `series.update()`.
- Fixed #14078, all points rendered in all series with [boost.usePreallocated](https://api.highcharts.com/highcharts/boost.usePreallocated) on.
- Fixed #14428, enabling `drilldown` through `Point.update()` did not work.
- Fixed #14214, parliament chart (item series type) threw error on negative values. Negative values should be ignored like in the pie series.
- Fixed #14433, dependency wheel data labels had wrong position for items covering more than 180 degrees of the wheel.
- Fixed #14260, series graph color was affected by `marker.fillColor` in Boost.
- Fixed #14289, histogram series entered an infinite loop when passed certain data values.
- Fixed #14379, when `scrollablePlotArea` was enabled, gauge axis was not scrolling along.
- Fixed #14440, `ColumnRangeSeries` missed `adjustForMissingColumns`.
- Fixed #13277, event listener leakage in several series and export module.
- Fixed regressions with `chart.update` and `chart.setSize`, causing side effects like stacks not updating and series not.
- Fixed #14023, for small numbers and decimals argument set to zero, the `numberFormater` returned wrong values.
- Fixed #13957, added error handler while mixed series data in boost.
- Fixed #14883, prototype pollution was possible through the `merge` function.