# Changelog for Highcharts v9.0.1 (2021-02-16)

- Exposed `Highcharts.AST` and provided samples of overriding the HTML allow lists.
- Auto compute heading level for the pre-chart accessibility description.
- Added success callback for `exportChartLocal`, see #11403.

## Bug fixes
- Fixed #12422 and #9124, un-boosted graphics remained visible after resetting zoom on boosted charts when using zones.
- Fixed #12517, `resetZoomButton` did not show when using `scrollablePlotArea`.
- Fixed #15045, [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) did not work with `columnrange` series.
- Fixed #11909, updating boost options did not work.
- Fixed #12031, tooltip `distance` did not scale correctly with [outside](https://api.highcharts.com/highcharts/tooltip.outside) set to `false`.
- Fixed #12047, some columns were not completely vertical when using boost with [useGPUTranslations](https://api.highcharts.com/highcharts/boost.useGPUTranslations) set to `false`.
- Fixed #12061, `stroke-width` animation did not work when using zones.
- Fixed #13222, chart size was wrong after exiting fullscreen.
- Fixed #15022, vertical panning was limited to the first series extremes after zooming in.
- Fixed #15037, a regression causing failure with text parsing in PhantomJS.
- Fixed #8862, #12112, y-axis did not stay fixed after [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update) when using `scrollablePlotArea`.
- Fixed #15009, setting `className` on points in venn series did not work.
- Fixed #12548, 3d scatter chart rendered no points when the first point had `z` set to `null`.
- Fixed #14973, pattern fill failed to render when `<base>` tag was present and `window.location` was manipulated via `history.pushState`.
- Fixed #14395, updating `colorAxis` legend layout did not work with non-cartesian series.
- Fixed #14954, offline export with [styledMode](https://api.highcharts.com/highcharts/chart.styledMode) enabled sometimes failed in IE.
- Fixed #14110, hovering labels with `useHTML` set to `true` threw in IE.
