# Changelog for Highcharts v9.1.0 (2021-05-04)

- Added `text` to axis label context, making it possible to insert the default formatting inside [labels.format](https://api.highcharts.com/highcharts/xAxis.labels.format).
- Added additional `item` object context for [lang.accessibility.legend.legendItem](https://api.highcharts.com/highcharts/lang.accessibility.legend.legendItem).

## Bug fixes
- Fixed #14966, selected null points generated NaN values in the SVG.
- Fixed #9549, column drag handle was not visible with reversed Y axis.
- Fixed #15291, inconsistent addition of symbols definitions in the SVG renderer.
- Fixed #15528, `labels.allowOverlap` set to `false` stopped working for axis tick labels after [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #11493, #13095, tooltip showed outside axis and plot bounds.
- Fixed #15520, space key fired legend item click twice in Firefox.
- Fixed #15523, [negativeColor](https://api.highcharts.com/highcharts/plotOptions.series.negativeColor) did not work for lollipop series.
- Fixed #15525, clicking data label did not drill down line and area series.
- Fixed #15560, dumbbell connectors remained visible after changing series type when markers were not rendered.
- Fixed #15555, removing dependency wheel points during animation threw.
- Fixed #15547, bullet target disappeared when combined with `rounded-corners` plugin.
- Fixed #15537, some data updates while dragging point threw.
- Fixed #13943, split tooltip was rendered to wrong side on smaller charts.
- Fixed #15534, updating area series containing null data to no data threw.
- Fixed #15509, `<u>` tag not working with `useHTML`.
- Fixed a regression, area series with empty data caused SVG error.
- Fixed #15488, square shape did not support rounded corners.
- Fixed #15489, polar spline series with null data did not render path.
- Fixed #15416, #15413, heatmap keyboard navigation not working after mouse interaction, and backwards navigation not working as expected.
- Fixed #15343, regression with treemap and sunburst keyboard navigation.
- Fixed #15447, wordcloud keyboard navigation, and added support for making the chart container a separate tab-stop.
- Fixed #15463, legend [symbolWidth](https://api.highcharts.com/highcharts/legend.symbolWidth) did not correctly default to [symbolHeight](https://api.highcharts.com/highcharts/legend.symbolHeight).
- Fixed #11336, no tooltip showed when hovering very small chart.
- Fixed #15436, previous legend items remained visible after dynamically adding color axis.
- Fixed #15434, plot band was not completely hidden when hiding series.
- Fixed #15438, polar chart with null data and accessibility module loaded threw.
- Fixed #15420, series with [zones](https://api.highcharts.com/highcharts/plotOptions.series.zones) or [negativeColor](https://api.highcharts.com/highcharts/plotOptions.series.negativeColor) enabled leaked memory on [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed #15412, some charts showed non-passive scroll-blocking warnings.
- Fixed #10464, halo position was wrong when using boost with multiple axes.
- Fixed #15392, boosted chart with empty data showed turbo warning.
- Fixed #15382, updating polar column to zero value did not work.
- Fixed #15377, inactive state with 0 opacity applied due to `inactiveOtherSeries` being `true` did not work for data labels and connectors.
- Fixed #15359, wrong `BubbleLegend` color in [styledMode](https://api.highcharts.com/highcharts/chart.styledMode).
- Fixed #14882, stacked area and [connectNulls](https://api.highcharts.com/highcharts/plotOptions.series.connectNulls) sometimes did not work correctly together.
- Fixed #14906, split tooltip flickered with `followPointer` enabled.
- Fixed #15160, inactive state was not always cleared on touch devices when clicking outside the chart.
- Fixed #15188, added error display fallback to the most recently added chart for debugger module.
- Fixed event handler leaks in fullscreen module, flags series and [scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea).
- Fixed #15018, tooltip [split](https://api.highcharts.com/highcharts/tooltip.split), [outside](https://api.highcharts.com/highcharts/tooltip.outside) and `useHTML` did not work together.
- Fixed #13449, updating [dataLabels.allowOverlap](https://api.highcharts.com/highcharts/plotOptions.series.dataLabels.allowOverlap) did not work.
- Fixed reset zoom and drillup button alignment after plot size changes, button alignment did not update when the plot size changed due to hiding or showing elements such as legend or title.
- Fixed #15179, crisping did not work correctly for subpixel radius markers.
- Fixed #15260, networkgraph point `className` option did not work.
- Fixed #15162, in styled mode, the font-size of the subtitle was not used like defined in Sass file.
- Fixed #15234, #15213, #13492, #2022, axis options passed in when creating chart got mutated.
- Fixed #15217, bar chart tooltip position was wrong with [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) enabled.
- Fixed #13646, the `color` option did not take effect in empty pie series.
- Fixed #13572, area series fill was not closed, making it hard to add a stroke for the area itself.
- Fixed #11687, `drillUpButton` did not have a fixed position when using [scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea).
- Fixed #15134, updating networkgraph series color did not work.
- Fixed #14980, toggling stacking with [centerInCategory](https://api.highcharts.com/highcharts/plotOptions.column.centerInCategory) enabled did not work.
- Fixed #15145, some data labels did not show in percent stacked bar or column charts when points were partially outside axis extremes.
- Fixed #9998, exporting menu was clipped below the chart.
- Fixed #10159, updating treemap data while traversed down threw.
- Fixed #11293, boosted chart rendered duplicate series when combined with responsive options.
- Fixed #15069, [panning](https://api.highcharts.com/highcharts/chart.panning) default `type` was missing.
- Fixed #14439, simulation of `packedBubble` stopping too early.
- Fixed #14448, #11614, drillup button disappeared when combined with a vertical [scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea) on inverted charts.
