# Changelog for Highcharts v9.1.1 (2021-06-04)

- Added new option for bullet chart, [targetOptions.borderRadius](https://api.highcharts.com/highcharts/plotOptions.bullet.targetOptions.borderRadius). See #15649.
- Improved legend accessibility by placing legend buttons in a list.

## Bug fixes
- Fixed #15401, console warning when loading funnel 3D module, `tableValues` invalid attribute.
- Fixed #15757, [heatmap.borderRadius](https://api.highcharts.com/highcharts/plotOptions.heatmap.borderRadius) did not work.
- Fixed #14780, offline exporting charts with HTML content to PNG or JPEG fell back to the export server even in browsers that supported it.
- Fixed issue with extraneous table caption HTML encoding in the export data module.
- Fixed #15701, tooltip text alignment broke when setting font size.
- Fixed #15811, setting `title.verticalAlign` to `middle` did not vertically center the title completely.
- Fixed #15667, scatter line showed on hover after updating `lineWidth` to `0`.
- Fixed #15639, error when calling `removePlotBand` after destroying `Axis`.
- Fixed #9612, panning after zooming sometimes broke with [pointPlacement](https://api.highcharts.com/highcharts/plotOptions.series.pointPlacement) set to `on` or `between`.
- Fixed handling of local time with Safari 14.1.
- Fixed #15771, drilldown failed when points were cropped from the start of the series.
- Fixed #14403, tooltip covered interactive elements like the legend, buttons or annotations. Added a CSS class, `highcharts-no-tooltip` that can be applied to elements to prevent the data tooltip covering them.
- Fixed #15746, heatmap select state color did not work correctly.
- Fixed #15708, heatmap null points missed `highcharts-null-point` class.
- Fixed #15698, Highcharts instance was accessed incorrectly on error.
- Fixed #15325, panning multiple axes did not work.
- Fixed #15685, boosted scatter chart with empty first series rendered ghost points.
- Fixed a [scrollablePlotArea](https://api.highcharts.com/highcharts/chart.scrollablePlotArea) regression, tooltip did not show sometimes.
- Fixed #15646, zones with no color set were invisible in boosted chart.
- Fixed #15640, legend items lost disabled state on keyboard navigation.
- Fixed #15654, shadow offset did not get applied on inverted charts.
- Fixed #15636, draggable point guide box was not big enough when the point was not fully inside.
- Fixed #15607, random stack labels with the value 0 showed when zooming in.
- Fixed #15521, inactive state remained on points after exiting chart with keyboard navigation.
