# Changelog for Highcharts v9.2.0 (2021-08-18)

- Improved ES module architecture with support for tree shaking of the most commonly used modules. See [#8667](https://github.com/highcharts/highcharts/issues/8667).
- Added new feature, [series.relativeXValue](https://api.highcharts.com/highcharts/plotOptions.series.relativeXValue), allowing point X values to be relative to the [series.pointStart](https://api.highcharts.com/highcharts/plotOptions.series.pointStart) and subject to [series.pointInterval](https://api.highcharts.com/highcharts/plotOptions.series.pointInterval) and [series.pointIntervalUnit](https://api.highcharts.com/highcharts/plotOptions.series.pointIntervalUnit).

## Bug fixes
- Fixed [#15938](https://github.com/highcharts/highcharts/issues/15938), charts still crashed in some legacy browsers where `Intl` was missing.
- Fixed [#15235](https://github.com/highcharts/highcharts/issues/15235), whitespace between HTML elements got removed.
- Fixed [#15986](https://github.com/highcharts/highcharts/issues/15986), accessibility exit anchor disappeared on `Chart.update`.
- Fixed [#15229](https://github.com/highcharts/highcharts/issues/15229), accessibility region labels were sometimes duplicated.
- Fixed [#16119](https://github.com/highcharts/highcharts/issues/16119), touch scrolling was blocked after zooming when single-finger panning was not enabled.
- Fixed [#16146](https://github.com/highcharts/highcharts/issues/16146), negative values broke sunburst chart.
- Fixed [#16153](https://github.com/highcharts/highcharts/issues/16153), `fontFamily` reset when updating [chart.style](https://api.highcharts.com/highcharts/chart.style).
- Fixed [#16126](https://github.com/highcharts/highcharts/issues/16126), printing chart in full screen with accessibility loaded threw.
- Fixed [#16112](https://github.com/highcharts/highcharts/issues/16112), axis options set by `setOptions` were not picked up by polar chart when chart axis options were set as an array.
- Fixed [#16104](https://github.com/highcharts/highcharts/issues/16104), chart warned about unsorted data when updating category names.
- Fixed [#14143](https://github.com/highcharts/highcharts/issues/14143), [#14434](https://github.com/highcharts/highcharts/issues/14434), [#13310](https://github.com/highcharts/highcharts/issues/13310), tooltip with [stickOnContact](https://api.highcharts.com/highcharts/tooltip.stickOnContact) and `useHTML` or [outside](https://api.highcharts.com/highcharts/tooltip.outside) enabled did not work properly.
- Fixed [#16080](https://github.com/highcharts/highcharts/issues/16080), [#13705](https://github.com/highcharts/highcharts/issues/13705), sankey chart with self-referential points broke on [redraw](https://api.highcharts.com/highcharts/chart.events.redraw).
- Fixed [#16084](https://github.com/highcharts/highcharts/issues/16084), [#13671](https://github.com/highcharts/highcharts/issues/13671), updating timeline chart did not work properly in some cases.
- Fixed [#15334](https://github.com/highcharts/highcharts/issues/15334), some waterfall data labels did not show for points below `threshold`.
- Fixed [#16062](https://github.com/highcharts/highcharts/issues/16062), lines after the first line break in text with `useHTML` set to `true` were misaligned in exported charts when [exporting.allowHTML](https://api.highcharts.com/highcharts/exporting.allowHTML) was set to `false`.
- Fixed [#16053](https://github.com/highcharts/highcharts/issues/16053), color axis disappeared after toggling legend.
- Fixed [#16044](https://github.com/highcharts/highcharts/issues/16044), draggable point guide box was not big enough when the point was partially outside the end of the axis.
- Fixed [#16042](https://github.com/highcharts/highcharts/issues/16042), 1px gaps showed between some xrange points when there was no gaps in the data.
- Fixed [#1441](https://github.com/highcharts/highcharts/issues/1441), `datetime` axis ticks did not get date/time formatting applied when [tickPositions](https://api.highcharts.com/highcharts/xAxis.tickPositions) were set.
- Fixed [#15777](https://github.com/highcharts/highcharts/issues/15777), plot line labels were not clipped.
- Fixed [#13840](https://github.com/highcharts/highcharts/issues/13840), 3d column chart with scrollbar showed points outside plot in upper left corner.
- Fixed [#15983](https://github.com/highcharts/highcharts/issues/15983), event did not get removed when updating it to `undefined`.
- Fixed [#15973](https://github.com/highcharts/highcharts/issues/15973), word cloud focus border position for rotated points was wrong in Firefox.
- Fixed [#12015](https://github.com/highcharts/highcharts/issues/12015), linked series did not get inactive state applied when hovering legend item.
- Fixed [#15946](https://github.com/highcharts/highcharts/issues/15946), unchanged markers set in options did not animate when updating data through [update](https://api.highcharts.com/highcharts/plotOptions.series.point.events.update).
- Fixed [#15449](https://github.com/highcharts/highcharts/issues/15449), HTML in exporting menu item text did not work.
- Fixed [#15922](https://github.com/highcharts/highcharts/issues/15922), heatmap data labels with `useHTML` enabled and default formatter did not work, per-point `borderColor` and `borderWidth` did not work.
- Fixed [#15902](https://github.com/highcharts/highcharts/issues/15902), legend proxy buttons did not update when updating series.
- Fixed 3d bug, z-axis updated twice on `Chart.update`.
- Fixed [#15862](https://github.com/highcharts/highcharts/issues/15862), `Chart.update` with `oneToOne` attempting to remove pane threw.
- Fixed [#9047](https://github.com/highcharts/highcharts/issues/9047), boosted series with null points showed warnings in some browsers.
- Fixed [#5430](https://github.com/highcharts/highcharts/issues/5430), marker shown on hover with disabled markers missed CSS class.
- Fixed [#15909](https://github.com/highcharts/highcharts/issues/15909), pie point with `visible` set to `false` and `useHTML` data labels threw.
