# Changelog for Highcharts v9.3.0 (2021-10-21)

- Added new offset options for nodes in Sankey and Organization chart, [[nodes.offsetHorizontal](https://api.highcharts.com/highcharts/series.sankey.nodes.offsetHorizontal)](https://api.highcharts.com/highcharts/series.sankey.nodes.offsetHorizontal) and [[nodes.offsetVertical](https://api.highcharts.com/highcharts/series.sankey.nodes.offsetVertical)](https://api.highcharts.com/highcharts/series.sankey.nodes.offsetVertical). See [#15225](https://github.com/highcharts/highcharts/issues/15225).
- Added new option, [annotations.crop](https://api.highcharts.com/highcharts/annotations.crop), allowing to hide annotations outside the plot area. See [#15399](https://github.com/highcharts/highcharts/issues/15399).
- Allow removing accessibility information sections by setting section formats to `null`.
- Support [series.accessibility.point](https://api.highcharts.com/highcharts/plotOptions.series.accessibility.point) options matching the top level `accessibility.point` options.
- Support `pageUp`/`pageDown` in legend keyboard navigation for scrolling between legend pages.
- Improvements to series keyboard navigation, now supporting `End`/`Home`/`PgUp`/`PgDown` keys.

## Bug fixes
- Fixed [#12169](https://github.com/highcharts/highcharts/issues/12169), allowing Blob offline export in Firefox.
- Fixed [#16150](https://github.com/highcharts/highcharts/issues/16150), pyramid shape was incorrect for inverted charts when `yAxis.width` set.
- Fixed [#16275](https://github.com/highcharts/highcharts/issues/16275), ticks on the axis weren't displayed when their value was too high.
- Fixed [#16165](https://github.com/highcharts/highcharts/issues/16165), border radius disappeared after hovering a point in heatmap.
- Fixed [#13780](https://github.com/highcharts/highcharts/issues/13780), tooltip was mispositioned when `yAxis` was reversed.
- Fixed [#12828](https://github.com/highcharts/highcharts/issues/12828), click event on point wasn't working on IE with color axis.
- Fixed issue [#15876](https://github.com/highcharts/highcharts/issues/15876), DOM order not following [keyboardNavigation.order](https://api.highcharts.com/highcharts/accessibility.keyboardNavigation.order).
- Fixed [#11756](https://github.com/highcharts/highcharts/issues/11756), adding image without optional parameters threw an error.
- Fixed [#15480](https://github.com/highcharts/highcharts/issues/15480) and [#16052](https://github.com/highcharts/highcharts/issues/16052), disabled point markers sometimes appeared on redraw with accessibility module loaded.
- Fixed [#13683](https://github.com/highcharts/highcharts/issues/13683), the last row of items in a paginated legend was not fully visible in edge cases.
- Fixed [#16004](https://github.com/highcharts/highcharts/issues/16004), a regression causing shared tooltip not to show for some axes with multiple differently positioned axes.
- Fixed [#16245](https://github.com/highcharts/highcharts/issues/16245), automatic [minRange](https://api.highcharts.com/highcharts/xAxis.minRange) did not consider [floor](https://api.highcharts.com/highcharts/xAxis.floor)/[ceiling](https://api.highcharts.com/highcharts/xAxis.ceiling).
- Fixed [#12961](https://github.com/highcharts/highcharts/issues/12961), the chart crashed when `axis.tickInterval` was negative.
- Fixed [#15117](https://github.com/highcharts/highcharts/issues/15117), [pointStart](https://api.highcharts.com/highcharts/plotOptions.series.pointStart) and [pointInterval](https://api.highcharts.com/highcharts/plotOptions.series.pointInterval) did not work with turboed 2d array data.
- Fixed [#16143](https://github.com/highcharts/highcharts/issues/16143), offline exporting hidden boosted series threw error 28.
- Fixed [#16176](https://github.com/highcharts/highcharts/issues/16176), funnel data labels with `rotation` set showed console error.
